unit Disc;

interface

uses
  MPlayer, Engine, Log;

type
  TDiscInfo = record
    Artist: string;
    Title: string;
    DiscID: string;
    TrackNames: array [1..99] of string;
  end;

function MakeDiscID(Player: TCDPlayer): string;
function MediaPresent(DeviceID: Word): Boolean;
procedure LoadDisc(DeviceID: Word);
function GetCurrentTrack(DeviceID: Word): Longint;
function MillisecondsToFrames(MS: Longint): Longint;
procedure MillisecToMinSec(Millisec: Longint; var Min, Sec: Longint);

implementation

uses
  MMSystem, SysUtils;

function MakeDiscID(Player: TCDPlayer): string;
var
  MagicNumber: Byte;
  ID, Temp: Longint;
  Minutes, Seconds, Frames: Byte;
  TrackNumber: Longint;
begin
  MagicNumber := 0;

  ID := 0;
  Player.SetMSF;
  for TrackNumber := 1 to Player.GetTrackCount do
  begin
    Temp := Player.GetTrackPosition(TrackNumber);
    Minutes := mci_MSF_Minute(Temp);
    Seconds := mci_MSF_Second(Temp);
    Frames := mci_MSF_Frame(Temp);
    ID := ID + (Minutes shl 16) + (Seconds shl 8) + Frames;
    if TrackNumber = 1 then
      MagicNumber := Frames;
  end;

  if Player.GetTrackCount < 3 then
  begin
    ID := ID + MagicNumber;
    Player.SetMS;
    ID := ID + MilliSecondsToFrames(Player.GetLength);
  end;

  Result := IntToHex(ID, 1);
end;

function MediaPresent(DeviceID: Word): Boolean;
var
  MCIStatus: TMCI_Status_Parms;
begin
  FillChar(MCIStatus, SizeOf(TMCI_Status_Parms), 0);
  MCIStatus.dwItem := MCI_STATUS_MEDIA_PRESENT;
  mciSendCommand(DeviceID, MCI_STATUS,
    MCI_STATUS_ITEM or MCI_WAIT,
    Longint(@MCIStatus));
  Result := (MCIStatus.dwReturn <> 0);
end;

procedure LoadDisc(DeviceID: Word);
var
  MCISet: TMCI_Set_Parms;
begin
  FillChar(MCISet, SizeOf(TMCI_Set_Parms), 0);
  mciSendCommand(DeviceID, MCI_SET,
    MCI_SET_DOOR_CLOSED, Longint(@MCISet));
end;

function GetCurrentTrack(DeviceID: Word): Longint;
var
  MCIStatus: TMCI_Status_Parms;
begin
  FillChar(MCIStatus, SizeOf(MCIStatus), #0);
  MCIStatus.dwItem := MCI_STATUS_CURRENT_TRACK;
  mciSendCommand(DeviceID, MCI_STATUS,
    MCI_STATUS_ITEM, Longint(@MCIStatus));
  Result := MCIStatus.dwReturn;
end;

function MillisecondsToFrames(MS: Longint): Longint;
const
  FRAMES_PER_SECOND = 75;
begin
  Result := MS * FRAMES_PER_SECOND div 1000;
  if MS <> (Result * 1000 div FRAMES_PER_SECOND) then
    Inc(Result);
end;

procedure MillisecToMinSec(Millisec: Longint; var Min, Sec: Longint);
begin
  Min := Millisec div 60000;
  Sec := (Millisec - (Min * 60000)) div 1000;
end;

end.
