// rle.cpp
#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <string.h>

void encode(ifstream&, ofstream&);
void decode(ifstream&, ofstream&);
void usage();

enum Operation { ENCODE, DECODE };

int main(int argc, char *argv[])
{
    if (argc < 4)
    {
        usage();
        return -1;
    }
    Operation op;
    if (strcmp(argv[1], "encode") == 0)
        op = ENCODE;
    else if (strcmp(argv[1], "decode") == 0)
        op = DECODE;
    else
    {
        usage();
        return -1;
    }

    ifstream inputFile(argv[2], ios::in | ios::binary);
    if (!inputFile)
    {
        cerr << "rle: can't open input file"
             << argv[2] << endl;
        return -1;
    }

    ofstream outputFile(argv[3], ios::out | ios::binary);
    if (!outputFile)
    {
        cerr << "rle: can't open output file"
             << argv[3] << endl;
        inputFile.close();
        return -1;
    }

    if (op == ENCODE)
        encode(inputFile, outputFile);
    else
        decode(inputFile, outputFile);

    inputFile.close();
    outputFile.close();
    return 0;
}

void encode(ifstream& in, ofstream& out)
{
    int runCount = 0;
    unsigned char currentByte, runByte;

    while (!in.eof())
    {
        in.get(currentByte);
        if (in.eof())
            break;
        if (runCount == 0)
        {
            runCount++;
            runByte = currentByte;
            continue;
        }
        else
        {
            if (runByte == currentByte)
            {
                runCount++;
                if (runCount == 255)
                {
                    out.put((unsigned char)runCount);
                    out.put(runByte);
                    runCount = 0;
                    continue;
                }
            }
            else // character changed
            {
                out.put((unsigned char)runCount);
                out.put(runByte);
                runCount = 1;
                runByte = currentByte;
            }
        }
    }

    if (runCount > 0)
    {
        out.put((unsigned char)runCount);
        out.put(runByte);
    }
}

void decode(ifstream& in, ofstream& out)
{
    unsigned char currentCount, currentByte;
    while (!in.eof())
    {
        in.get(currentCount);
        if (in.eof())
            break;
        in.get(currentByte);
        for (int i = 0; i < currentCount; i++)
            out.put(currentByte);
    }
}

void usage()
{
    cerr << "usage: rle encode|decode "
         << "inputfile outputfile" << endl;
}

