/*
Joystickien ksittelyrutiini, MikroBitti 3/96.
Copyright(C) 1996, Tarmo Toikkanen

Ohjelman kntminen:
 Borland C: bcc joystick.cpp
		 DJGPP: gcc joystick.cpp -lpc -o joystick.out
						strip joystick.out
						coff2exe joystick.out
*/

#include <dos.h>
#include <conio.h>

#ifndef __BORLANDC__
	#include <djgppstd.h>	// Nm rivit tarvitaan vain DJGPP-kntjll
	#include <pc.h>
#endif

// Vakiomrittelyt eri tietojen bittimaskeille
#define JOY1X 0x01	// Akselibitit ovat aina 1 jos joystick
#define JOY1Y 0x02	// ei ole kytkettyn.
#define JOY2X 0x04
#define JOY2Y 0x08
#define JOY1A 0x10	// Nappibitit ovat 1 kun nappula ei ole painettuna
#define JOY1B 0x20
#define JOY2A 0x40
#define JOY2B 0x80

// Suurin "suunta"-funktion palauttama arvo (+/-)
#define MAXVAL 10

typedef unsigned short word;
typedef unsigned char byte;

// Joystickien tmnhetkiset tarkat tiedot
word joy[2][4];				// 2 tikkua: X, Y, 1-nappi, 2-nappi
// Joystickien kalibroinnin perusteella lasketut arvot
word jval[2][2][MAXVAL*2];	// 2 tikkua: 2 suuntaa ja (+/-)MAXVAL arvoa

// Lukee joystickien asennot
// Parametri "tikut": bittimaski, kertoo halutut akselit
void lue_tikut(short tikut) {
	register word laskuri=0;
	register byte arvo,akselit;
	akselit=tikut;	// Aktivoidaan halutut akselit
	disable();			// Keskeytykset pois
	outportb(0x201,0);	// Aloitetaan tikkujen varaaminen
	do {	// Odotetaan kunnes halutut akselit ovat nollautuneet
		arvo=inportb(0x201);
		laskuri++;		// Laskurin kasvatus
		if ((arvo&JOY1X)==0 && (akselit&JOY1X)!=0) {
			joy[0][0]=laskuri;
			akselit-=JOY1X;
		}
		if ((arvo&JOY1Y)==0 && (akselit&JOY1Y)!=0) {
			joy[0][1]=laskuri;
			akselit-=JOY1Y;
		}
		if ((arvo&JOY2X)==0 && (akselit&JOY2X)!=0) {
			joy[1][0]=laskuri;
			akselit-=JOY2X;
		}
		if ((arvo&JOY2Y)==0 && (akselit&JOY2Y)!=0) {
			joy[1][1]=laskuri;
			akselit-=JOY2Y;
		}
	} while (arvo&tikut);
	enable();			// Keskeytykset plle
	joy[0][2]=(arvo&0x10)?0:1;	// Nappuloiden lukeminen
	joy[0][3]=(arvo&0x20)?0:1;
	joy[1][2]=(arvo&0x40)?0:1;
	joy[1][3]=(arvo&0x80)?0:1;
}

short etsi_tikut(void) {
	short tikut=0;
	byte arvo;
	delay(10);		// Odotetaan ett joystickit ovat varmasti resetoituneet
	arvo=inportb(0x201);		// Luetaan tiedot
	if ((arvo&JOY1X)==0) tikut+=JOY1X;	// Aktiiviset joystickit ovat
	if ((arvo&JOY1Y)==0) tikut+=JOY1Y;	// nollanneet bittins
	if ((arvo&JOY2X)==0) tikut+=JOY2X;
	if ((arvo&JOY2Y)==0) tikut+=JOY2Y;
	return(tikut);
}

void kalibroi(short tikut) {
	char n,m,v;
	// Joystickien kalibrointitietot
	word jcal[2][2][3];		// 2 tikkua: 2 suuntaa: 3 arvoa (min,med,max)
	lue_tikut(tikut);		// Alustetaan kalibrointirajat
	for(n=0;n<2;n++) for(m=0;m<2;m++) {
		jcal[n][m][0]=joy[n][m];
		jcal[n][m][2]=joy[n][m];
	}
	cprintf("\r\nPyrit joystickit kaikkien riasentojensa kautta.");
	cprintf("\r\nKun olet valmis, jt tikut keskelle");
	cprintf("\r\nja paina jotain nappia\n");
	while (kbhit()) getch();	// Tyhjennetn nppinpuskuri
	while(1) {		// Haetaan riasennot
		lue_tikut(tikut);
		cprintf("\r       X1: %04i Y1: %04i X2: %04i Y2: %04i",
			joy[0][0],joy[0][1],joy[1][0],joy[1][1]);
		for(n=0;n<2;n++) for(m=0;m<2;m++) {
			if (joy[n][m]<jcal[n][m][0]) jcal[n][m][0]=joy[n][m];
			if (joy[n][m]>jcal[n][m][2]) jcal[n][m][2]=joy[n][m];
		}
		if (kbhit() || joy[0][2] || joy[0][3] || joy[1][2] || joy[1][3]) break;
	}
	while (kbhit()) getch();	// Tyhjennetn nppinpuskuri
	lue_tikut(tikut);		// Haetaan keskikohdat

	for(n=0;n<2;n++) for(m=0;m<2;m++)
		jcal[n][m][1]=joy[n][m];
	// Lasketaan saaduista arvoista rajat lopputuloksille

	for(n=0;n<2;n++) for(m=0;m<2;m++) {
		word diff,margin;

		diff=jcal[n][m][1]-jcal[n][m][0];
		margin=diff*0.15;
		diff*=0.85;
		for(v=0;v<MAXVAL;v++)
			jval[n][m][v]=diff*(v+1)/MAXVAL+jcal[n][m][0];

		diff=jcal[n][m][2]-jcal[n][m][1];
		margin=diff*0.15;
		diff*=0.85;
		for(v=0;v<MAXVAL;v++)
			jval[n][m][v+MAXVAL]=diff*v/MAXVAL+jcal[n][m][1]+margin;
	}
}

// Yls ja vasemmalle negatiivisia, alas ja oikealle positiivisia
// Parametrit: t=tikku (0/1), a=akseli (0/1)
char suunta(char t,char a) {
	for(short n=0;n<MAXVAL*2;n++)
		if (joy[t][a]<=jval[t][a][n]) return(n-MAXVAL);
	return(MAXVAL);
}


// Palauttaa yksi jos painettu, nolla jos ei
// Parametrit: t=tikku (0/1), n=nappi (0/1)
char nappi(char t,char n) {
	return(joy[t][n+2]);
}

int main(void) {
	short tikut=etsi_tikut();		// Haetaan aktiiviset akselit
	kalibroi(tikut);						// Kalibroidaan ohjaimet
	while(!kbhit()) {
		lue_tikut(tikut);					// Asennon haku
		delay(100);
		cprintf("\r");
		for(char n=0;n<2;n++)			// Tulosten nytt
			cprintf("  Joy %i: (%i,%i) (%i,%i)    ",
				n+1,suunta(n,0),suunta(n,1),nappi(n,0),nappi(n,1));
	}
	return(0);
}