/*Sprite-tekniikkaa esittelev ohjelma, Copyright (C) 1995, Tarmo Toikkanen

  Ohjelma kntyy sellaisenaan sek Borlandin C++:lla ett DJGPP:lla.

  Kntmiskomennot:
		bcc sprite1.cpp
  tai
		gcc -v sprite1.cpp -lpc -o sprite1.out
	  strip sprite1.out
	  coff2exe sprite1.out
*/

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#ifdef __BORLANDC__
	#include <mem.h>
	// Normaalisti grafiikkamuisti alkaa osoitteesta A0000h
	char *puskuri,*ruutu=(char *)(0xA0000000);
	#define random rand
	#define int long
#else
	#include <djgppstd.h>
	#include <pc.h>
	// DJGPP:ss grafiikkamuisti alkaa osoitteesta D0000h
	char *puskuri,*ruutu=(char *)(0xD0000000);
	#define CLK_TCK 1000000
#endif

#define LEVEYS	 320				// Ruudun mitat
#define KORKEUS 200
#define TRANS	 0   				// Vri 0 mritetn lpinkyvksi
#define SPRITENUM 4 				// Tehdn 4 spriten taulukko

#define TOP 1						// Ruudun laitojen arvot
#define BOTTOM 2              //   trmystarkistuksia varten
#define LEFT 4
#define RIGHT 8


/************************************************************************/
/*                           LUOKKA: BitMap                             */
/************************************************************************/

class BitMap {
	unsigned short w,h;				// Leveys ja korkeus
	char *kuva;							// Osoitin kuvatietoihin
public:
	BitMap(char *);
	~BitMap(void);
	int Leveys(void) { return(w); }
	int Korkeus(void) { return(h); }
	unsigned char Pixel(short x,short y);
	void Ruudulle(short,short,short tr=-1);	// Piirt bittikartan puskuriin
};

// Konstruktori: parametrina PCX-tiedoston nimi
BitMap::BitMap(char *tiedosto) {
	unsigned int p;
	short tavu,tavu2;
	FILE *pcx=fopen(tiedosto,"rb");		// Avataan tiedosto
	if (!pcx) {									// Tarkistetaan
		textmode(0x3);
		fprintf(stderr,"Tiedosto %s puuttuu!",tiedosto);
		exit(1);
	}
	fseek(pcx,8,SEEK_SET);					// Kohdassa 8 on (leveys-1)
	w=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Luetaan integer
	h=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Seuraavana on (korkeus-1)
	kuva=(char *)malloc(w*h);		// Varataan muistia kuvalle
	if (kuva==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui tiedoston %s kohdalla!",tiedosto);
		exit(1);
	}
	fseek(pcx,128,SEEK_SET);				// Kohdassa 128 alkaa kuvatieto
	for(p=0; p<w*h;) {						// Luetaan korkeus*leveys tavua
		tavu=fgetc(pcx);						// Luetaan tavu
		if (tavu>192) {						// Jos tavu>192, sen perss
			tavu2=fgetc(pcx);					//   oleva tavu2 on toistettava
			for(;tavu>192; tavu--)        //   (tavu-192) kertaa
				kuva[p++]=tavu2;
		} else kuva[p++]=tavu;				// Muussa tapauksessa tavu
	}												//   esiintyy vain kerran
	fclose(pcx);
}

// Destruktori, vapauttaa kuvalle varatun muistin
BitMap::~BitMap(void) {
	free(kuva);
}

// Piirt bittikartan ruudulle kohtaan (x,y)
void BitMap::Ruudulle(short x,short y,short tr) {
	unsigned short xx,yy;
	if (tr==TRANS) {			// Piirretn lpinkyvn
		for(yy=0; yy<h; yy++) if (y + yy < KORKEUS)
			for(xx=0; xx<w; xx++) if (x + xx < LEVEYS)
				if (kuva[yy*w + xx]!=TRANS)
					puskuri[(y+yy)*LEVEYS + x+xx]=kuva[yy*w + xx];
	} else {						// Piirretn tydellisen
		for(yy=0; yy<h; yy++) if (y + yy < KORKEUS)
			for(xx=0; xx<w; xx++) if (x + xx < LEVEYS)
				puskuri[(y+yy)*LEVEYS + x+xx]=kuva[yy*w + xx];
	}
}

// Palauttaa pikselin vrin haetussa kohdassa
unsigned char BitMap::Pixel(short x,short y) {
	if (x<0 || x>=w || y<0 || y>=h) return(TRANS);
	return(kuva[y*w+x]);
}

/************************************************************************/
/*                           LUOKKA: Sprite                             */
/************************************************************************/

class Sprite {
	short x,y,bx,by;				// Koordinaatit (uudet ja vanhat)
	short dirx,diry;    			// Liikkumasuunnat
	unsigned short w,h;			// Spriten koko (taustaa varten)
	BitMap *bitmap;				// Osoitin spriten kuvaan
	char *tausta; 			// Osoitin taustan varastotilaan
public:

	// Tietojenpalautsfunktiot
	short GetX(void) { return(x); }
	short GetY(void) { return(y); }
	short GetXSuunta(void) { return(dirx); }
	short GetYSuunta(void) { return(diry); }
	// Liikkumasuuntien mrittelyfunktiot
	void XSuunta(short dx) { dirx=dx; }
	void YSuunta(short dy) { diry=dy; }
	void XYSuunta(short dx,short dy) { dirx=dx; diry=dy; }

	// Siirt spriten paikkaan (nx,ny)
	void Paikka(short nx,short ny) { x=nx; y=ny; }
	// Siirt sprite liikkumasuuntien mukaan
	void Siirry(void) { x+=dirx; y+=diry; }

	Sprite(short,short);			// Konstruktori, luo uuden spriten
	~Sprite(void);					// Destruktori, poistaa spriten

	// Yhdist bittikartan spriteen
	void Link(BitMap *b) { bitmap=b; }
	// Palauttaa spriten kytss olevan bittikartan
	BitMap *Kuva(void) { return(bitmap); }

	// Tarkistukset ruudun laitaan ja toisiin spriteihin
	short Laidassa(void);
	short Osuma(Sprite *s);

	// Piirto- ja pyyhintfunktiot
	void Ruudulle(void);
	void Pyyhi(void);
};

// Konstruktori: parametreina spriten leveys ja korkeus
Sprite::Sprite(short leveys,short korkeus) {
	w=leveys; h=korkeus; 						// Talletetaan kokotiedot
	tausta=(char *)malloc(w*h);		// Varataan taustavarasto
	if (tausta==NULL) {  						// Tarkistetaan ett muistia riitti
		textmode(0x3);
		fprintf(stderr,"Muisti loppui spritess!");
		exit(3);
	}
	x=0; y=0; bx=0; by=0; dirx=0; diry=0;	// Alustetaan muuttujat
}

// Destruktori: vapauttaa taustavaraston
Sprite::~Sprite(void) {
	free(tausta);
}

// Tarkistaa trmk kaksi sprite toisiinsa seuraavalla pivityksell
// Parametrina osoitin spriteen jonka kanssa trmys tarkistetaan
// Palauttaa 1 jos trmys tapahtuu, muuten 0
short Sprite::Osuma(Sprite *s) {
	unsigned short xx,yy;
		// Lasketaan spritejen vliset etisyydet
	unsigned int dx=abs(x + dirx - (s->x + s->GetXSuunta()));
	unsigned int dy=abs(y + diry - (s->y + s->GetXSuunta()));
		// Ovatko spritet osittain toisensa pll?
	if (abs(dx) > w && abs(dx) > s->w) return(0);
	if (abs(dy) > h && abs(dy) > s->h) return(0);
		// Jos ovat, niin kydn ne lpi pikseli pikselilt
		// Jos kaksi pllekkist pikseli on lpinkymttmi,
		//   on trmys tapahtunut
	for(yy=0; yy<h; yy++) for(xx=0; xx<w; xx++)
		if (yy-dy < s->h && xx-dx < s->w)
			if (Kuva()->Pixel(yy,xx)!=TRANS &&
				 s->Kuva()->Pixel(yy-dy,xx-dx)!=TRANS) return(1);
	return(0);
}

// Tarkistaa trmk sprite ruudun laitaan seuraavalla pivityksell
// Palauttaa bittikentn jossa on tiedot kaikista laidoista
short Sprite::Laidassa(void) {
	short res=0;
	if (x + dirx < 0) res|=LEFT;
	else if (x + dirx + w>=LEVEYS) res|=RIGHT;
	if (y + diry < 0) res|=TOP;
	else if (y + diry + h>=KORKEUS) res|=BOTTOM;
	return(res);
}

// Poistaa spriten ruudulta ja palauttaa taustan entiselleen
void Sprite::Pyyhi(void) {
	unsigned short xx,yy;
	for(yy=0; yy<h; yy++) if (by + yy < KORKEUS)
		for(xx=0; xx<w; xx++) if (bx + xx < LEVEYS)
			puskuri[(by+yy)*LEVEYS + bx+xx]=tausta[yy*w + xx];
}

// Piirt spriten ruudulle ja ottaa sen ylikirjoittaman taustan talteen
void Sprite::Ruudulle(void) {
	unsigned short xx,yy,siirros;
	unsigned char pixel;
	bx=x; by=y;		 // Pivitetn vanhoille koordinaateille uudet arvot
	for(yy=0; yy<h; yy++) if (y + yy < KORKEUS)
		for(xx=0; xx<w; xx++) if (x + xx < LEVEYS)
			tausta[yy*w + xx]=puskuri[(y+yy)*LEVEYS + x+xx];
	Kuva()->Ruudulle(x,y,TRANS);	// Piirretn sprite lpinkyvn
}

/************************************************************************/
/*                                Pkoodi                              */
/************************************************************************/

// Muuttaa Nytnohjaimen paletin PCX-tiedoston mukaan
void Paletti(char *tiedosto) {
	short c;
	unsigned char paletti[256*3];	// Tilaa 256 vrin RGB-arvoille
	//union REGS r;
	//struct SREGS sr;
	FILE *pcx=fopen(tiedosto,"rb");	// Avataan tiedosto
	fseek(pcx,-768l,SEEK_END);			// Paletti alkaa 768 tavua lopusta lukien
	for(c=0;c<256;c++) {					// Luetaan kaikki 256 vri
		paletti[c*3+0]=fgetc(pcx)/4;
		paletti[c*3+1]=fgetc(pcx)/4;	// Saatu arvo jaetaan neljll koska
		paletti[c*3+2]=fgetc(pcx)/4;	//   VGA-paletissa on vain arvot 0..63
	}
	fclose(pcx);
	outportb(0x3C8,0);
	for(c=0;c<256*3;c++) outportb(0x03C9,paletti[c]);
}

// Kopioi kaksoispuskurin sislln ruudulle
void inline Puskuri(void) { memcpy(ruutu,puskuri,64000); }

int main(void) {
	short n,x,y,viive,ulos;
	unsigned long frames=0;
	// Varataan kaksoispuskurille muistia
	puskuri=(char *)malloc(64000);
	if (puskuri==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui puskurissa!");
		exit(3);
	}
	// Luodaan animaatio-, bittikartta- ja spritetaulukot
	BitMap *tausta,*mbnet,*star;
	Sprite *kuvat[SPRITENUM];

	tausta=new BitMap("MB.PCX");		// Ladataan tausta,
	tausta->Ruudulle(0,0);           // piirretn puskuriin
	delete(tausta);						// ja poistetaan muistista

	mbnet=new BitMap("MBNET.PCX");	// Ladataan bittikartat spriteille
	star=new BitMap("STAR.PCX");

	x=star->Leveys();
	y=star->Korkeus();
	for(n=0;n<2;n++) {						// Ladataan spritet muistiin
		kuvat[n]=new Sprite(x,y);
		kuvat[n]->Link(star);				// ja linkataan kuvat niihin
		kuvat[n]->Paikka(random()%(320-x),random()%(200-x));
		kuvat[n]->XYSuunta(random()%(3)-1,random()%(3)-1);
	}
	x=mbnet->Leveys();
	y=mbnet->Korkeus();
	for(n=2;n<SPRITENUM;n++) {
		kuvat[n]=new Sprite(x,y);
		kuvat[n]->Link(mbnet);
		kuvat[n]->Paikka(random()%(320-x),random()%(200-x));
		kuvat[n]->XYSuunta(random()%(3)-1,random()%(3)-1);
	}

	textmode(0x13); 		// Siirrytn grafiikkatilaan 13h eli 320x200x256
	Paletti("MB.PCX");	// Luetaan paletti
	Puskuri();				// Kopioidaan puskuri (eli tausta) nytlle
	ulos=0; viive=20;
	clock_t start=clock();
	while(!ulos) {				// Plooppi
		frames++;
		for(n=0; n<SPRITENUM; n++) {	// Jokaiselle spritelle:
			kuvat[n]->Ruudulle();		//   Piirretn puskuriin,
			kuvat[n]->Siirry();			//   siirretn liikkumasuuntien mukaan
		}
		Puskuri();							// Kopioidaan puskuri nytlle
		delay(viive);						// Odotetaan

		for(x=0;x<SPRITENUM;x++) {
			n=kuvat[x]->Laidassa();		// Kimmotetaan sprite seinmist
			if      (n&TOP || n&BOTTOM) kuvat[x]->XSuunta(random()%(3)-1);
			else if (n&LEFT || n&RIGHT) kuvat[x]->YSuunta(random()%(3)-1);
			if      (n&TOP)             kuvat[x]->YSuunta(1);
			else if (n&BOTTOM)          kuvat[x]->YSuunta(-1);
			if      (n&LEFT)            kuvat[x]->XSuunta(1);
			else if (n&RIGHT)           kuvat[x]->XSuunta(-1);

			// Tarkistetaan spritejen vliset trmykset ja yritetn
			// etsi satunnaiset kimpoamissuunnat poispin toisistaan
			for(y=x+1; y<SPRITENUM; n=0,y++)
				while(kuvat[x]->Osuma(kuvat[y])) {
					kuvat[x]->XYSuunta(random()%(5)-2, random()%(5)-2);
					kuvat[y]->XYSuunta(random()%(5)-2, random()%(5)-2);
					if (n++>16) break;
					if (kbhit()) break;
				}
		}
		// Poistetaan spritet puskurista knteisess jrjestyksess
		for(n=SPRITENUM-1;n>=0;n--) kuvat[n]->Pyyhi();

		while (kbhit()) {		// Nppimisttarkistus
			switch(getch()) {
				case '-': viive++; break;
				case '+': if (viive) viive--; break;
				case 27: case 'q': case 'Q': case 'x': case 'X': ulos=1; break;
			}
		}
	}
	clock_t end=clock();
	for(n=0; n<SPRITENUM; n++) delete(kuvat[n]);	// Poistetaan spritet
	delete(mbnet); delete(star);						// ja bittikartat
	free(puskuri);										// Poistetaan puskuri
	textmode(3);                                 // Siirrytn tekstitilaan
	printf("\nPivityksi: %li\nTickej: %li",frames,end-start);
	printf("\nRuudunpivityksi %.2f sekunnissa",
		(float)frames/(end-start)*CLK_TCK);			// Nytetn pivitysnopeus
	return(0);
}
