#include <dos.h>
#ifdef __cplusplus
 #define INTARG ...
#else
 #define INTARG void
#endif
extern unsigned _heaplen = 256; /*Kasa ja pino pienennetn*/
extern unsigned _stklen  = 128;
char ctrl,alt,hotkey,esc,active;
/*Eri vaiheet: 0: Odottaa hotkeyt (vaihe 2 mys)*/
/*             1: Valitaan alue hiirell*/
/*             2: Odotetaan: molemmat hiiren napit alas*/
/*             3: Sytetn tieto nppimistpuskuriin*/
volatile char puskuri[80*25];
int paikka;
void interrupt ( *vanha_i9)(INTARG);
void interrupt ( *vanha_i1c)(INTARG);
void interrupt i1c(INTARG);
void interrupt i9(INTARG);
void _loadds _saveregs mark(void);

int main(void) {
	vanha_i9 = getvect(0x9);  /*Talletetaan vanhat vektorit*/
	vanha_i1c= getvect(0x1c);
	setvect(0x9, i9);         /*Koukutetaan vektorit*/
	setvect(0x1c, i1c);
	ctrl=0; alt=0; hotkey=0; esc=0; active=0; paikka=0;
	keep(0, (_SS + (_SP/16) - _psp)); /*Jtetn ohjelma muistiin*/
	return 0;                         /* ja palataan DOSiin*/
}

void interrupt i9(INTARG) {
	switch(inp(0x60)) {
		case 0x1D: ctrl=1; break;
		case 0x9d: ctrl=0; break;
		case 0x38: alt=1; break;
		case 0xB8: alt=0; break;
		case 0x56: hotkey=1; break;
		case 0xD6: hotkey=0; break;
		case 0x01: esc=1; break;
		case 0x81: esc=0; break;
	}
	/*Hotkeyt toimivat vain vaiheissa 0 ja 2*/
	if (active==0 || active==2) {
		if (ctrl && !alt && hotkey) {
			active=1; /*Vaihe 1: alueen valinta*/
			outp(0x20,0x20); /*Keskeytys on pttynyt*/
			mark(); /*Valitaan alue hiirell*/
			active=2; /*Vaihe 2: hiiren odottaminen*/
		} else if (ctrl && alt && hotkey) {
			active=1; /*Muistista poisto; vaihe 1 est looppaamisen*/
			outp(0x20,0x20); /*Keskeytys on pttynyt*/
			if (getvect(0x9)==i9 && getvect(0x1c)==i1c) {
				setvect(0x9,vanha_i9); /*Poistetaan koukutukset*/
				setvect(0x1C,vanha_i1c);
				asm cli /*Estetn hardware-keskeytykset*/
				_ES=_psp;
				_AH=0x49;
				geninterrupt(0x21); /*Poistetaan ohjelma*/
				_ES=peek(_psp,0x2C);
				_AH=0x49;
				geninterrupt(0x21); /*Poistetaan ympristalue*/
				asm sti /*Vapautetaan hardware-keskeytykset*/
			}
			active=0;
		} else vanha_i9(); /*Jos hotkeyt ei painettu, kutsutaan*/
	} else vanha_i9();    /* DOSin omaa ksittelij*/
}

/*Colorize vritt tekstiruudulla yhden merkin*/
void colorize(char col,char row,char value) {
	int register cor=row*160+col*2+1;
	pokeb(0xB800,cor,peekb(0xB800,cor)+value);
}

/*Loopcolorize vrj colorizen avulla suuren alueen ruudusta*/
void loopcolorize(char col1,char col2,char row1,char row2,char value) {
	char x,y;
	for(y=row1;y<=row2;y++) for(x=col1;x<=col2;x++) colorize(x,y,value);
}

/*Alueen valinta hiirell*/
void mark(void) {
	char startx,starty,ostartx,ostarty,endx,endy,oendx,oendy,x,y,mkeys;
	ostartx=startx=40; ostarty=starty=12;
	_AX=0x0004;
	_CX=startx*8;
	_DX=starty*8;
	geninterrupt(0x33); /*Siirretn hiiri keskelle ruutua*/
	colorize(startx,starty,16);
	for(;;) { /*Odotetaan kunnes hiiren nappia painetaan*/
		if (esc) goto mainskip; /*ESC:ll psee pois*/
		_AX=0x0003;
		geninterrupt(0x33);
		/*Hiiren koordinaatit muutetaan riveiksi ja kolumneiksi*/
		startx=_CX/8; starty=_DX/8;
		if (_BX) break;
		if (ostartx!=startx || ostarty!=starty) {
			colorize(ostartx,ostarty,-16);
			colorize(startx,starty,16);
			ostartx=startx; ostarty=starty;
		}
	}
	colorize(ostartx,ostarty,-16);

	colorize(startx,starty,16);
	oendx=startx; oendy=starty;
	for(;;) { /* Odotetaan kunnes napit pstetn irti*/
		if (esc) goto mainskip; /*ESC:ll psee pois*/
		_AX=0x0003;
		geninterrupt(0x33);
		endx=_CX/8; endy=_DX/8;
		if (!_BX) break;
		mkeys=_BX;
		if (oendx!=endx || oendy!=endy) {
			loopcolorize(startx,oendx,starty,oendy,-16);
			loopcolorize(startx,endx,starty,endy,+16);
			oendy=endy; oendx=endx;
		}
	}
	loopcolorize(startx,oendx,starty,oendy,-16);

	/*Luetaan nyttmuistista valittu alue puskuriin*/
	for(paikka=0,y=starty;y<=endy;y++) {
		for(x=startx;x<=endx;x++) puskuri[paikka++]=peekb(0xB800,y*160+x*2);
		switch(mkeys) {
			case 2: puskuri[paikka++]=0x0D; break;	 /*Enter rivien pern*/
			default: puskuri[paikka++]=0x20; break; /*Space rivien pern*/
		}
		if (paikka>=80*24-1) break;
	}
	puskuri[paikka+1]=0;
	paikka=0;
mainskip:
	return;
}

void interrupt i1c(INTARG) {
	vanha_i1c(); /*Kutsutaan vanhaa ksittelij*/
	switch(active) {
	case 2: /*Jos odotetaan hiiren nappeja*/
		_AX=0x0003;
		geninterrupt(0x33);
		_BX&=0x003;
		if (_BX!=3) break;
		active=3;
	case 3:
		for(;;) {
			_CL=puskuri[paikka++];
			if (!_CL) {  /*Jos puskurista saadaan 0*/
				active=0; /* lopetetaan syttminen*/
				break;
			}
			_AH=0x05;    /*Tuupataan merkki puskuriin*/
			geninterrupt(0x16);
			if (_AL) {   /*Jos ei onnistu, yritetn*/
				paikka--; /* uudelleen seuraavalla kerralla*/
				break;
			}
		}
		break;
	}
}