public class Tulostaulu {
  private Pelitulos[] tulokset;

  public Tulostaulu(int koko) {
    tulokset = new Pelitulos[Math.abs(koko)];
    tyhjenn();
  }

  public Tulostaulu() { this(10); }

  public int palauta_koko() { return tulokset.length; }

  public void tyhjenn() {
    for (int i = 0; i < tulokset.length; i++) {
      tulokset[i] = new Pelitulos(0, "---");
    }
  }

  public int lis(Pelitulos uusi) {
    int kolo = 0;

    try {
      // etsi kolo johon uusi tulos sopii
      while (tulokset[kolo].palauta_tulos() >
             uusi.palauta_tulos()) {
        kolo++; // poikkeuksen ksittely hoitaa ylimenon
      }

      // pudota kaikkia kolon alapuolisia tuloksia
      for (int pudotuskohta = tulokset.length - 1;
           pudotuskohta > kolo;
           pudotuskohta--) {
        tulokset[pudotuskohta] = tulokset[pudotuskohta - 1];
      }

      tulokset[kolo] = uusi;
    }
    catch (ArrayIndexOutOfBoundsException e) {
      kolo = -1;
    }
    return kolo;
  }

  public int lis(int tulos, String nimi) {
    return lis(new Pelitulos(tulos, nimi));
  }

  public String toString() {
    StringBuffer teksti = new StringBuffer();        
    for (int i = 0; i < tulokset.length; i++) {
      teksti.append(tulokset[i] + "\n");
    }
    return teksti.toString();
  }
}

