unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, ComCtrls, StdCtrls;

type
  TMainForm = class(TForm)
    PnlControls: TPanel;
    LblHeight: TLabel;
    TxtHeight: TEdit;
    UpdHeight: TUpDown;
    LblWeight: TLabel;
    TxtWeight: TEdit;
    UpdWeight: TUpDown;
    PbxResult: TPaintBox;
    StatusBar: TStatusBar;
    LblIndex: TLabel;
    TrkIndex: TTrackBar;
    LblBottomIndex: TLabel;
    LblTopIndex: TLabel;
    procedure UpdHeightClick(Sender: TObject;
                             Button: TUDBtnType);
    procedure UpdWeightClick(Sender: TObject;
                             Button: TUDBtnType);
    procedure PbxResultPaint(Sender: TObject);
    procedure TrkIndexChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    LastBMI: Integer;
    function BodyMassIndex: Integer;
    procedure UpdateDisplay;
    function SolveForWeight(Height, BMI: Integer): Integer;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

function TMainForm.BodyMassIndex: Integer;
begin
  Result := Round(UpdWeight.Position /
                  Sqr(UpdHeight.Position / 100.0));
end;

procedure TMainForm.UpdateDisplay;
type
  TBMIType = (Under, Normal, SlightlyOver, VeryOver);
const
  ResultTexts: array [Under..VeryOver] of string =
    ('Alipaino!', 'Normaali paino',
     'Liev ylipaino', 'Huomattava ylipaino!');
  ResultColors: array [Under..VeryOver] of TColor =
    (clRed, clGreen, clYellow, clRed);
var
  TheNumber: Integer;
  Situation: TBMIType;
  S: string;
  W, H: Integer;
begin
  TheNumber := BodyMassIndex;
  if TheNumber = LastBMI then
    Exit;

  if TheNumber < 20 then
    Situation := Under
  else if (TheNumber >= 20) and (TheNumber <= 25) then
    Situation := Normal
  else if (TheNumber > 25) and (TheNumber < 30) then
    Situation := SlightlyOver
  else if TheNumber >= 30 then
    Situation := VeryOver;

  with PbxResult.Canvas do
  begin
    Brush.Color := ResultColors[Situation];
    Ellipse(0, 0, PbxResult.Width, PbxResult.Height);

    Font.Name := 'Arial';
    Font.Size := 36;
    if Situation = SlightlyOver then
      Font.Color := clBlack
    else
      Font.Color := clWhite;

    S := IntToStr(TheNumber);
    W := TextWidth(S);
    H := TextHeight(S);

    TextOut((PbxResult.Width - W) div 2,
            (PbxResult.Height - H) div 2, S);
  end;
  StatusBar.SimpleText := ResultTexts[Situation];
end;

procedure TMainForm.UpdHeightClick(Sender: TObject;
                                   Button: TUDBtnType);
begin
  PbxResult.Refresh;
end;

procedure TMainForm.UpdWeightClick(Sender: TObject;
                                   Button: TUDBtnType);
begin
  PbxResult.Refresh;
end;

procedure TMainForm.PbxResultPaint(Sender: TObject);
begin
  UpdateDisplay;
end;

procedure TMainForm.TrkIndexChange(Sender: TObject);
begin
  UpdWeight.Position := SolveForWeight(UpdHeight.Position,
                                       TrkIndex.Position);
  PbxResult.Refresh;
end;

function TMainForm.SolveForWeight(Height,
                                  BMI: Integer): Integer;
begin
  Result := Round(BMI * (Sqr(Height / 100)));
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  LastBMI := 0;
end;

end.

