/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xmms.h"
#ifdef WITH_SM
#include <X11/SM/SMlib.h>

static SmcConn smc_conn = NULL;
static IceConn ice_conn;
static char *session_id;

static void sm_save_yourself(SmcConn c, SmPointer p, int save_type, Bool shutdown,
		      int interact_style, Bool fast)
{
	GDK_THREADS_ENTER();
	save_config();
	SmcSaveYourselfDone(c, TRUE);
	GDK_THREADS_LEAVE();
}

static void sm_shutdown_cancelled(SmcConn c, SmPointer a)
{
}

void sm_save_complete(SmcConn c, SmPointer a)
{
}

static void sm_die(SmcConn c, SmPointer arg)
{
	GDK_THREADS_ENTER();
	mainwin_quit_cb();
	GDK_THREADS_LEAVE();
}

static void ice_handler(gpointer data, gint source, GdkInputCondition condition)
{
	IceProcessMessages(data, NULL, NULL);
}

#endif

void sm_init(int argc, char **argv)
{
#ifdef WITH_SM
	SmPropValue program_val = { strlen(PACKAGE), PACKAGE };
	SmPropValue userid_val  = { 0, NULL };
	SmPropValue restart_val = { strlen(argv[0]), argv[0] };
	SmProp program_prop =
	{ (char *)SmProgram, (char *)SmARRAY8, 1, &program_val };
	SmProp userid_prop =
	{ (char *)SmUserID, (char *)SmARRAY8, 1, &userid_val };
	SmProp restart_prop =
	{ (char *)SmRestartCommand, (char *)SmLISTofARRAY8, 1,
	  (SmPropValue *)&restart_val };
	SmProp clone_prop =
	{ (char *)SmCloneCommand, (char *)SmLISTofARRAY8, 1,
	  (SmPropValue *)&restart_val };
	 SmProp *props[] = {
              &program_prop,
              &userid_prop,
              &restart_prop,
              &clone_prop
          };
	 SmcCallbacks smcall;
	 char errstr[256];

	 if(getenv("SESSION_MANAGER"))
	 {
		 memset(&smcall, 0, sizeof(smcall));
		 userid_val.value = g_strdup_printf("%d", geteuid());
		 userid_val.length = strlen(userid_val.value);
		 smcall.save_yourself.callback = sm_save_yourself;
		 smcall.die.callback = sm_die;
		 smcall.save_complete.callback = sm_save_complete;
		 smcall.shutdown_cancelled.callback = sm_shutdown_cancelled;
		 
		 smc_conn = SmcOpenConnection(NULL,
					      NULL,
					      SmProtoMajor, SmProtoMinor,
					      SmcSaveYourselfProcMask |
					      SmcSaveCompleteProcMask |
					      SmcShutdownCancelledProcMask |
					      SmcDieProcMask,
					      &smcall,
					      NULL, &session_id,
					      sizeof(errstr), errstr);
		 if(!smc_conn)
			 return;
		 SmcSetProperties(smc_conn,
				  sizeof(props)/sizeof(props[0]),
				  (SmProp **)&props);
		 ice_conn = SmcGetIceConnection(smc_conn);
		 gdk_input_add(IceConnectionNumber(ice_conn), GDK_INPUT_READ, ice_handler, ice_conn);
	 }
#endif
}

void sm_cleanup(void)
{
#ifdef WITH_SM
	if(smc_conn)
		SmcCloseConnection(smc_conn, 0, NULL);
#endif
}
