#include "config.h"

#include <xmms/plugin.h>
#include <gtk/gtk.h>

static void init(void);
static void cleanup(void);
static void about(void);
static void configure(void);
static int mod_samples(gpointer *d, gint length, AFormat afmt, gint srate, gint nch);

EffectPlugin stereo_ep =
{
	NULL,
	NULL,
	"Extra Stereo Plugin " VERSION,
	init,
	cleanup,
	about,
	configure,
	mod_samples
};

static const char about_text[] = "Extra Stereo Plugin\n\n\
By Johan Levin 1999.";

GtkWidget *conf_dialog = NULL, *about_dialog = NULL;
GtkObject *adjustment;
gfloat old_value;

EffectPlugin *get_eplugin_info(void)
{
	return &stereo_ep;
}

static void init(void)
{
	adjustment = gtk_adjustment_new(2.5, 0.0, 15.0 + 1.0, 0.1, 1.0, 1.0);
}

static void cleanup(void)
{
	gtk_object_unref(adjustment);
}

static gint about_destroy_cb(GtkWidget * w, GdkEventAny * e, gpointer data)
{
	gtk_widget_destroy(about_dialog);
	about_dialog = NULL;
	return TRUE;
}

static void about_ok_cb(GtkButton * button, gpointer data)
{
	gtk_widget_destroy(about_dialog);
	about_dialog = NULL;
}

static void about(void)
{
	GtkWidget *hbox, *text, *button;

	if (about_dialog != NULL)
		return;

	about_dialog = gtk_dialog_new();
	gtk_signal_connect(GTK_OBJECT(about_dialog), "destroy",
			   GTK_SIGNAL_FUNC(about_destroy_cb), NULL);
	gtk_window_set_title(GTK_WINDOW(about_dialog), "Configure Extra Stereo");

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_dialog)->vbox), hbox,
			   TRUE, TRUE, 5);
	gtk_widget_show(hbox);

	text = gtk_text_new(NULL, NULL);
	gtk_text_set_editable(GTK_TEXT(text), FALSE);
	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
			about_text, strlen(about_text));
	gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 5);
	gtk_widget_show(text);

	button = gtk_button_new_with_label("Ok");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_dialog)->action_area),
			   button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(about_ok_cb), NULL);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);
	gtk_widget_show(about_dialog);
}

static gint conf_destroy_cb(GtkWidget * w, GdkEventAny * e, gpointer data)
{
	GTK_ADJUSTMENT(adjustment)->value = old_value;
	gtk_signal_emit_by_name(adjustment, "changed");
	gtk_widget_destroy(conf_dialog);
	conf_dialog = NULL;
	return TRUE;
}

static void conf_ok_cb(GtkButton * button, gpointer data)
{
	gtk_widget_destroy(conf_dialog);
	conf_dialog = NULL;
}

static void conf_cancel_cb(GtkButton * button, gpointer data)
{
	GTK_ADJUSTMENT(adjustment)->value = old_value;
	gtk_signal_emit_by_name(adjustment, "changed");
	gtk_widget_destroy(conf_dialog);
	conf_dialog = NULL;
}

static void configure(void)
{
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *scale;
	GtkWidget *button;

	if (conf_dialog != NULL)
		return;

	if (adjustment)
		old_value = GTK_ADJUSTMENT(adjustment)->value;
	conf_dialog = gtk_dialog_new();
	gtk_signal_connect(GTK_OBJECT(conf_dialog), "destroy",
			   GTK_SIGNAL_FUNC(conf_destroy_cb), NULL);
	gtk_window_set_title(GTK_WINDOW(conf_dialog), "Configure Extra Stereo");

	label = gtk_label_new("Effect intensity:");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(conf_dialog)->vbox), label,
			   TRUE, TRUE, 0);
	gtk_widget_show(label);

	hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(conf_dialog)->vbox), hbox,
			   TRUE, TRUE, 10);
	gtk_widget_show(hbox);

	scale = gtk_hscale_new(GTK_ADJUSTMENT(adjustment));
	gtk_object_ref(adjustment);
	gtk_box_pack_start(GTK_BOX(hbox), scale, TRUE, TRUE, 10);
	gtk_widget_show(scale);

	button = gtk_button_new_with_label("Ok");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(conf_dialog)->action_area),
			   button, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(conf_ok_cb), NULL);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(conf_dialog)->action_area), button,
			   TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(conf_cancel_cb), NULL);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_widget_show(conf_dialog);
}

static int mod_samples(gpointer *d, gint length, AFormat afmt, gint srate, gint nch)
{
	int i;
	double avg, ldiff, rdiff, tmp, mul;
	gint16  *data = (gint16 *)*d;

	if (!(afmt == FMT_S16_NE || (afmt == FMT_S16_LE && G_BYTE_ORDER == G_LITTLE_ENDIAN) || (afmt == FMT_S16_BE && G_BYTE_ORDER == G_BIG_ENDIAN)) || nch != 2)
		return length;

	mul = GTK_ADJUSTMENT(adjustment)->value;

	for (i = 0; i < length / 2; i += 2)
	{
		avg = (data[i] + data[i + 1]) / 2;
		ldiff = data[i] - avg;
		rdiff = data[i + 1] - avg;

		tmp = avg + ldiff * mul;
		if (tmp < -32768)
			tmp = -32768;
		if (tmp > 32767)
			tmp = 32767;
		data[i] = tmp;

		tmp = avg + rdiff * mul;
		if (tmp < -32768)
			tmp = -32768;
		if (tmp > 32767)
			tmp = 32767;
		data[i + 1] = tmp;
	}
	return length;
}
