/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.Menu;
import netscape.application.MenuItem;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class MenuView
extends View {
    Menu menu;
    MenuItem selectedItem;
    public MenuView owner;
    public MenuView child;
    InternalWindow menuWindow;
    int type;
    int itemHeight = 17;
    boolean transparent = false;
    static final String MENU_KEY = "menu";
    static final String OWNER_KEY = "owner";
    static final String CHILD_KEY = "child";
    static final String MENUWINDOW_KEY = "menuWindow";
    static final String MENUITEMHEIGHT_KEY = "itemHeight";
    static final String TYPE_KEY = "type";
    static final String TRANSPARENT_KEY = "transparent";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public MenuView() {
        this(0, 0, 0, 0, null, null);
    }

    public MenuView(Menu menu) {
        this(0, 0, 0, 0, menu, null);
    }

    public MenuView(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null, null);
    }

    public MenuView(int n, int n2, int n3, int n4, Menu menu) {
        this(n, n2, n3, n4, menu, null);
    }

    public MenuView(int n, int n2, int n3, int n4, Menu menu, MenuView menuView) {
        super(n, n2, n3, n4);
        this.menu = menu != null ? menu : new Menu(true);
        this.owner = menuView;
        this.menuWindow = this.createMenuWindow();
        this.menuWindow.addSubview(this);
        if (this.menu.isTopLevel()) {
            this.type = 0;
            this.setHorizResizeInstruction(2);
        } else {
            this.type = 1;
        }
        this.menu.menuView = this;
    }

    protected InternalWindow createMenuWindow() {
        InternalWindow internalWindow = new InternalWindow(0, 0, 0, 0);
        internalWindow.setType(0);
        internalWindow.setLayer(511);
        internalWindow.setCanBecomeMain(false);
        internalWindow._contentView.setTransparent(true);
        internalWindow.setScrollsToVisible(true);
        return internalWindow;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int type() {
        return this.type;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public Menu menu() {
        return this.menu;
    }

    public void setOwner(MenuView menuView) {
        this.owner = menuView;
    }

    public MenuView owner() {
        return this.owner;
    }

    public Color backgroundColor() {
        return this.menu.backgroundColor();
    }

    public Border border() {
        return this.menu.border();
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.menuWindow.setTransparent(bl);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setItemHeight(int n) {
        if (n > 0) {
            this.itemHeight = n;
            return;
        }
        this.itemHeight = this.minItemHeight();
    }

    public int itemHeight() {
        if (this.itemHeight > 0) {
            return this.itemHeight;
        }
        this.setItemHeight(this.minItemHeight());
        return this.itemHeight;
    }

    public int minItemHeight() {
        int n = 0;
        int n2 = this.menu.itemCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.menu.itemAt(n3).minHeight();
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        return n;
    }

    public int minItemWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.menu.itemCount()) {
            int n3 = this.menu.itemAt(n2).minWidth();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public Size minSize() {
        int n;
        int n2;
        int n3 = this.menu.itemCount();
        if (this.type == 0) {
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                MenuItem menuItem = this.menu.itemAt(n4);
                n2 += menuItem.minWidth();
                ++n4;
            }
            n = this.itemHeight();
        } else {
            n2 = this.minItemWidth();
            n = n3 * this.itemHeight();
        }
        return new Size(n2 += this.border().widthMargin(), n += this.border().heightMargin());
    }

    public MenuItem itemForPoint(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.menu.itemCount()) {
            Rect rect = this.rectForItemAt(n4);
            if (rect.contains(n, n2)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        MenuItem menuItem = n3 >= 0 ? this.menu.itemAt(n3) : null;
        return menuItem;
    }

    public int selectedIndex() {
        MenuItem menuItem = this.selectedItem();
        if (menuItem == null) {
            return -1;
        }
        return this.menu.indexOfItem(menuItem);
    }

    public MenuItem selectedItem() {
        return this.selectedItem;
    }

    public void selectItem(MenuItem menuItem) {
        if (!menuItem.isEnabled()) {
            return;
        }
        if (this.selectedItem != menuItem) {
            if (this.selectedItem != null) {
                this.selectedItem.setSelected(false);
                this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(this.selectedItem)));
            }
            menuItem.setSelected(true);
            this.selectedItem = menuItem;
            this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(menuItem)));
        }
    }

    public void deselectItem() {
        if (this.selectedItem != null) {
            this.selectedItem.setSelected(false);
            this.addDirtyRect(this.rectForItemAt(this.menu.indexOfItem(this.selectedItem)));
            this.selectedItem = null;
        }
    }

    public Rect rectForItemAt(int n) {
        int n2;
        int n3;
        if (n < 0 || n >= this.menu.itemCount()) {
            return null;
        }
        int n4 = 0;
        if (this.type == 0) {
            n3 = 0;
            int n5 = 0;
            while (n5 < n) {
                MenuItem menuItem = this.menu.itemAt(n5);
                n4 += menuItem.minWidth();
                ++n5;
            }
            n2 = this.menu.itemAt(n).minWidth();
        } else {
            n3 = this.itemHeight() * n;
            n2 = this.bounds.width - this.border().widthMargin();
        }
        Rect rect = Rect.newRect(n4 += this.border().leftMargin(), n3 += this.border().topMargin(), n2, this.itemHeight());
        return rect;
    }

    public Rect interiorRect() {
        Rect rect = new Rect(this.border().leftMargin(), this.border().topMargin(), this.bounds.width - this.border().widthMargin(), this.bounds.height - this.border().heightMargin());
        return rect;
    }

    public void drawItemAt(int n) {
        Rect rect = this.rectForItemAt(n);
        this.draw(rect);
    }

    protected MenuView createMenuView(Menu menu) {
        return new MenuView(0, 0, 0, 0, menu, this);
    }

    MenuView mainOwner() {
        MenuView menuView = this.owner;
        while (menuView.owner() != null) {
            menuView = menuView.owner();
        }
        return menuView;
    }

    boolean performCommandForKeyStroke(KeyStroke keyStroke, int n) {
        if (Application.application().activeMenuViews.count() > 0) {
            return false;
        }
        if (this.window() != null && !this.descendsFrom(this.rootView()._mainWindow)) {
            return false;
        }
        if (n == 2 || n == 1) {
            KeyEvent keyEvent = new KeyEvent(0L, keyStroke.key, keyStroke.modifiers, true);
            return this.menu.handleCommandKeyEvent(keyEvent);
        }
        return false;
    }

    void mouseWillDown(MouseEvent mouseEvent) {
        RootView rootView = Application.application().firstRootView();
        if (rootView != this.rootView()) {
            this.hideAll();
            return;
        }
        MouseEvent mouseEvent2 = this.rootView().convertEventToView(this, mouseEvent);
        if (this.containsPoint(mouseEvent2.x, mouseEvent2.y)) {
            return;
        }
        if (this.selectedItem() != null) {
            MenuView menuView = this.child;
            while (menuView != null) {
                Rect rect = new Rect(menuView.bounds);
                menuView.superview().convertRectToView(null, rect, rect);
                if (Rect.contains(rect.x, rect.y, rect.width, rect.height, mouseEvent.x, mouseEvent.y)) {
                    return;
                }
                menuView = menuView.child;
            }
        }
        this.hideAll();
    }

    void hideAll() {
        Application.application().removeActiveMenuView(this);
        if (this.child != null) {
            this.child.hide();
        }
        if (this.isVisible()) {
            this.hide();
        }
        this.deselectItem();
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (this.owner != null) {
            return true;
        }
        MenuItem menuItem = this.itemForPoint(mouseEvent.x, mouseEvent.y);
        if (menuItem == null || !menuItem.isEnabled()) {
            if (this.child != null) {
                this.child.hide();
            }
            this.deselectItem();
            return true;
        }
        if (this.selectedItem != null && menuItem == this.selectedItem) {
            if (this.isVisible()) {
                return true;
            }
            Application.application().removeActiveMenuView(this);
            if (this.child != null) {
                this.child.hide();
                this.child = null;
            }
            this.deselectItem();
            return true;
        }
        this.selectItem(menuItem);
        if (menuItem.isEnabled() && menuItem.hasSubmenu()) {
            MenuView menuView = this.createMenuView(menuItem.submenu());
            menuView.show(this.rootView(), mouseEvent);
            this.child = menuView;
        }
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        MenuItem menuItem = this.itemForPoint(mouseEvent.x, mouseEvent.y);
        if (!Rect.contains(0, 0, this.width(), this.height(), mouseEvent.x, mouseEvent.y)) {
            menuItem = null;
            if (this.owner != null && this.child == null || this.owner == null && this.child == null && this.isVisible()) {
                this.deselectItem();
            }
        }
        if (menuItem != null && !menuItem.isEnabled()) {
            return;
        }
        MenuView menuView = this.child;
        while (menuView != null && menuView.isVisible()) {
            Rect rect = new Rect(menuView.bounds);
            MouseEvent mouseEvent2 = this.convertEventToView(menuView, mouseEvent);
            if (Rect.contains(rect.x, rect.y, rect.width, rect.height, mouseEvent2.x, mouseEvent2.y)) {
                menuItem = menuView.itemForPoint(mouseEvent2.x, mouseEvent2.y);
                if (menuItem != null) {
                    menuView.mouseDragged(mouseEvent2);
                    menuView.autoscroll(mouseEvent2);
                    return;
                }
            } else if (menuView.child == null) {
                if (menuView.selectedItem() == null) {
                    menuView.autoscroll(mouseEvent2);
                }
                menuView.deselectItem();
            }
            menuView = menuView.child;
        }
        if (menuItem != null && menuItem != this.selectedItem()) {
            if (this.selectedItem != null && this.selectedItem.hasSubmenu() && this.child != null && this.child.isVisible()) {
                this.child.hide();
                this.child = null;
            }
            this.selectItem(menuItem);
            if (menuItem.hasSubmenu()) {
                menuView = this.createMenuView(menuItem.submenu());
                menuView.show(this.rootView(), mouseEvent);
                this.child = menuView;
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        MenuView menuView;
        MenuItem menuItem = null;
        menuItem = this.itemForPoint(mouseEvent.x, mouseEvent.y);
        if (this.owner == null && this.selectedItem == menuItem) {
            if (this.isVisible() && this.selectedItem != null) {
                Application.application().removeActiveMenuView(this);
                this.hide();
                this.menu.performCommand("", menuItem);
            } else {
                return;
            }
        }
        if (this.owner == null && menuItem == null) {
            menuView = this.child;
            while (menuView.child != null) {
                menuView = menuView.child;
            }
            menuView.mouseUp(this.convertEventToView(menuView, mouseEvent));
        }
        if (this.owner != null && this.selectedItem != null) {
            menuItem = this.selectedItem;
            Application.application().removeActiveMenuView(this.mainOwner());
            this.hide();
            menuView = this.owner;
            while (menuView.owner() != null) {
                menuView.hide();
                menuView = menuView.owner();
            }
            menuView.hide();
            this.menu.performCommand("", menuItem);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.owner == null && this.selectedItem != null || this.isVisible()) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void drawView(Graphics graphics) {
        this.border().drawInRect(graphics, 0, 0, this.width(), this.height());
        int n = this.menu.itemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            MenuItem menuItem = this.menu.itemAt(n3);
            Rect rect = this.rectForItemAt(n3);
            n2 += rect.width;
            if (graphics.clipRect().intersects(rect)) {
                graphics.pushState();
                graphics.setClipRect(rect);
                if (!this.isTransparent()) {
                    graphics.setColor(this.backgroundColor());
                    graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                }
                boolean bl = this.type != 0;
                menuItem.drawInRect(graphics, rect, bl);
                graphics.popState();
                Rect.returnRect(rect);
            }
            ++n3;
        }
        if (n2 < this.interiorRect().width && this.type == 0 && !this.isTransparent()) {
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(this.interiorRect().x + n2, this.interiorRect().y, this.interiorRect().width - n2, this.interiorRect().height);
        }
    }

    public void show(RootView rootView, MouseEvent mouseEvent) {
        int n;
        int n2;
        Rect rect;
        if (this.menu.itemCount() == 0) {
            return;
        }
        int n3 = this.minItemWidth() + this.border().widthMargin() + 20;
        int n4 = this.itemHeight() * this.menu.itemCount() + this.border().heightMargin();
        this.sizeTo(n3, n4);
        Menu menu = this.menu.superitem() != null ? this.menu.superitem().supermenu() : this.menu;
        MenuView menuView = this.owner != null ? this.owner : this;
        Rect rect2 = Rect.newRect(0, 0, this.width(), this.height());
        menuView.convertRectToView(null, rect2, rect2);
        if (rootView.windowClipView() != null && this.menuWindow.layer() != 511) {
            rootView.convertRectToView(rootView.windowClipView(), rect2, rect2);
        }
        if ((rect = menuView.rectForItemAt(menuView.selectedIndex())) == null) {
            rect = new Rect(0, 0, 0, 0);
        }
        if (menu.isTopLevel() && menuView.type == 0) {
            n2 = rect2.x + rect.x - menuView.border().leftMargin();
            n = rect2.y + menuView.height();
        } else if (this.menu.isTopLevel() && this.type == 1) {
            n2 = mouseEvent.x;
            n = mouseEvent.y;
        } else {
            n2 = rect2.x + rect.width + menuView.border().widthMargin() - 3;
            n = rect2.y + rect.maxY() - rect.height - menuView.border().topMargin();
        }
        int n5 = this.width();
        this.menuWindow.setBounds(n2, n, this.width(), this.height());
        this.sizeTo(n5, this.height());
        Rect.returnRect(rect2);
        Rect.returnRect(rect);
        menuView = this.owner != null ? this.mainOwner() : this;
        Application.application().addActiveMenuView(menuView);
        this.menuWindow.setRootView(rootView);
        this.menuWindow.show();
    }

    public void hide() {
        if (this.menuWindow.isVisible()) {
            this.menuWindow.hide();
        }
        if (this.selectedItem != null && this.selectedItem.hasSubmenu()) {
            this.child.hide();
            this.child = null;
        }
        this.deselectItem();
    }

    public boolean isVisible() {
        return this.menuWindow.isVisible();
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    void autoscroll(MouseEvent mouseEvent) {
        Rect rect = Rect.newRect();
        this.computeVisibleRect(rect);
        if (!rect.contains(mouseEvent.x, mouseEvent.y)) {
            if (mouseEvent.y < rect.y) {
                Rect rect2 = Rect.newRect(rect.x, mouseEvent.y, rect.width, this.itemHeight());
                this.scrollRectToVisible(rect2);
                Rect.returnRect(rect2);
            } else if (mouseEvent.y > rect.maxY()) {
                Rect rect3 = Rect.newRect(rect.x, mouseEvent.y - this.itemHeight(), rect.width, this.itemHeight());
                this.scrollRectToVisible(rect3);
                Rect.returnRect(rect3);
            }
        }
        Rect.returnRect(rect);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.MenuView", 1);
        classInfo.addField(MENU_KEY, (byte)18);
        classInfo.addField(OWNER_KEY, (byte)18);
        classInfo.addField(CHILD_KEY, (byte)18);
        classInfo.addField(MENUWINDOW_KEY, (byte)18);
        classInfo.addField(MENUITEMHEIGHT_KEY, (byte)8);
        classInfo.addField(TYPE_KEY, (byte)8);
        classInfo.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(MENU_KEY, this.menu);
        encoder.encodeObject(OWNER_KEY, this.owner);
        encoder.encodeObject(CHILD_KEY, this.child);
        encoder.encodeObject(MENUWINDOW_KEY, this.menuWindow);
        encoder.encodeInt(MENUITEMHEIGHT_KEY, this.itemHeight);
        encoder.encodeInt(TYPE_KEY, this.type);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.menu = (Menu)decoder.decodeObject(MENU_KEY);
        this.owner = (MenuView)decoder.decodeObject(OWNER_KEY);
        this.child = (MenuView)decoder.decodeObject(CHILD_KEY);
        this.menuWindow = (InternalWindow)decoder.decodeObject(MENUWINDOW_KEY);
        this.itemHeight = decoder.decodeInt(MENUITEMHEIGHT_KEY);
        this.type = decoder.decodeInt(TYPE_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
    }
}

