/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.IOException;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPControl;
import netscape.ldap.client.opers.JDAPAddResponse;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPCompareResponse;
import netscape.ldap.client.opers.JDAPDeleteResponse;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNResponse;
import netscape.ldap.client.opers.JDAPModifyResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResult;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class JDAPMessage {
    protected int m_msgid;
    protected JDAPProtocolOp m_protocolOp;
    protected JDAPControl[] m_controls;

    public JDAPMessage(int n, JDAPProtocolOp jDAPProtocolOp) {
        this.m_msgid = n;
        this.m_protocolOp = jDAPProtocolOp;
    }

    public JDAPMessage(int n, JDAPProtocolOp jDAPProtocolOp, JDAPControl[] jDAPControlArray) {
        this.m_msgid = n;
        this.m_protocolOp = jDAPProtocolOp;
        this.m_controls = jDAPControlArray;
    }

    public JDAPMessage(BERElement bERElement) throws IOException {
        if (bERElement.getType() != 48) {
            throw new IOException("SEQUENCE in jdap message expected");
        }
        BERSequence bERSequence = (BERSequence)bERElement;
        BERInteger bERInteger = (BERInteger)bERSequence.elementAt(0);
        this.m_msgid = bERInteger.getValue();
        BERElement bERElement2 = bERSequence.elementAt(1);
        if (bERElement2.getType() != -1) {
            throw new IOException("TAG in protocol operation is expected");
        }
        BERTag bERTag = (BERTag)bERElement2;
        switch (bERTag.getTag() & 0x1F) {
            case 1: {
                this.m_protocolOp = new JDAPBindResponse(bERElement2);
                break;
            }
            case 4: {
                this.m_protocolOp = new JDAPSearchResponse(bERElement2);
                break;
            }
            case 3: 
            case 5: {
                this.m_protocolOp = new JDAPSearchResult(bERElement2);
                break;
            }
            case 7: {
                this.m_protocolOp = new JDAPModifyResponse(bERElement2);
                break;
            }
            case 9: {
                this.m_protocolOp = new JDAPAddResponse(bERElement2);
                break;
            }
            case 11: {
                this.m_protocolOp = new JDAPDeleteResponse(bERElement2);
                break;
            }
            case 13: {
                this.m_protocolOp = new JDAPModifyRDNResponse(bERElement2);
                break;
            }
            case 15: {
                this.m_protocolOp = new JDAPCompareResponse(bERElement2);
                break;
            }
            case 19: {
                this.m_protocolOp = new JDAPSearchResultReference(bERElement2);
                break;
            }
            case 24: {
                this.m_protocolOp = new JDAPExtendedResponse(bERElement2);
                break;
            }
            default: {
                throw new IOException("Unknown rotocol operation");
            }
        }
        if (bERSequence.size() >= 3 && (bERTag = (BERTag)bERSequence.elementAt(2)).getTag() == 160) {
            BERSequence bERSequence2 = (BERSequence)bERTag.getValue();
            this.m_controls = new JDAPControl[bERSequence2.size()];
            int n = 0;
            while (n < bERSequence2.size()) {
                this.m_controls[n] = new JDAPControl(bERSequence2.elementAt(n));
                ++n;
            }
        }
    }

    public int getId() {
        return this.m_msgid;
    }

    public JDAPProtocolOp getProtocolOp() {
        return this.m_protocolOp;
    }

    public JDAPControl[] getControls() {
        return this.m_controls;
    }

    public void write(OutputStream outputStream) throws IOException {
        BERSequence bERSequence = new BERSequence();
        BERInteger bERInteger = new BERInteger(this.m_msgid);
        bERSequence.addElement(bERInteger);
        BERElement bERElement = this.m_protocolOp.getBERElement();
        if (bERElement == null) {
            throw new IOException("Bad BER element");
        }
        bERSequence.addElement(bERElement);
        if (this.m_controls != null) {
            BERSequence bERSequence2 = new BERSequence();
            int n = 0;
            while (n < this.m_controls.length) {
                bERSequence2.addElement(this.m_controls[n].getBERElement());
                ++n;
            }
            BERTag bERTag = new BERTag(160, bERSequence2, true);
            bERSequence.addElement(bERTag);
        }
        bERSequence.write(outputStream);
    }

    public String toString() {
        return "[JDAPMessage] " + this.m_msgid + " " + this.m_protocolOp.toString();
    }
}

