/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.peer.ButtonPeer;
import sun.awt.motif.MComponentPeer;

class MButtonPeer
extends MComponentPeer
implements ButtonPeer {
    native void create(MComponentPeer var1);

    public native void setLabel(String var1);

    MButtonPeer(Button button) {
        super(button);
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((Button)this.target).getLabel()) + 14, fontMetrics.getHeight() + 8);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void action() {
        this.postEvent(new ActionEvent(this.target, 1001, ((Button)this.target).getActionCommand()));
    }

    public void print(Graphics graphics) {
        Button button = (Button)this.target;
        Dimension dimension = button.size();
        Color color = button.getBackground();
        Color color2 = button.getForeground();
        graphics.setColor(color);
        graphics.fillRect(2, 2, dimension.width - 3, dimension.height - 3);
        this.draw3DRect(graphics, color, 1, 1, dimension.width - 2, dimension.height - 2, true);
        graphics.setColor(color2);
        graphics.setFont(button.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = button.getLabel();
        graphics.drawString(string, (dimension.width - fontMetrics.stringWidth(string)) / 2, (dimension.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

