/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import sun.awt.macos.MComponentPeer;
import sun.awt.macos.MToolkit;

public class MTextAreaPeer
extends MComponentPeer
implements TextAreaPeer {
    Boolean mEditable;

    public MTextAreaPeer(TextArea textArea) {
        super(textArea);
    }

    native void create(MComponentPeer var1);

    void initialize() {
        TextArea textArea = (TextArea)this.target;
        String string = textArea.getText();
        if (string != null) {
            this.setText(string);
        }
        this.select(textArea.getSelectionStart(), textArea.getSelectionEnd());
        this.setEditable(textArea.isEditable());
        super.initialize();
    }

    public void setBackground(Color color) {
        TextArea textArea = (TextArea)this.target;
        if (textArea.isEditable()) {
            color = color.brighter();
        }
        super.setBackground(color);
    }

    public native void setEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void insertText(String var1, int var2);

    public native void replaceText(String var1, int var2, int var3);

    public native void reshape(int var1, int var2, int var3, int var4);

    public void setCaretPosition(int n) {
        throw new AWTError("setCaretPosition is unimplemented.");
    }

    public int getCaretPosition() {
        throw new AWTError("getCaretPosition is unimplemented.");
    }

    public void insert(String string, int n) {
        this.insertText(string, n);
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceText(string, n, n2);
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n, n2);
    }

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    public Dimension minimumSize() {
        return this.minimumSize(10, 60);
    }

    public Dimension preferredSize(int n, int n2) {
        return this.minimumSize(n, n2);
    }

    public Dimension minimumSize(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n2 + 20, fontMetrics.getHeight() * n + 20);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void handleTextChanged() {
        MToolkit.postEvent(new TextEvent(this.target, 900));
    }
}

