/*
 * MultiMail offline mail reader
 * OMEN

 Copyright (c) 1999 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef OMEN_H
#define OMEN_H

#include "pktbase.h"

class omen : public pktbase
{
	struct AREAs {
		char *name;
		int num, nummsgs, attr;
		char numA[10];	// padded to deal with alignment bug (EMX)
	} *areas;

	// SYSTEMxy.BBS records:
	struct ATMP {
		unsigned char BrdNum, BrdStatus, BrdHighNum, BrdNameLen;
		char BrdName[16];
	} *areatmp;

	FILE *infile;
	char extent[4];

	int numMsgs;
	void buildIndices();
	char *nextLine();
	void readSystemBBS();
 public:
	omen(mmail *);
	~omen();
	int getXNum(int);
	file_header *getFileList();
	area_header *getNextArea();
	int getNoOfLetters();
	letter_header *getNextLetter();
	const char *getBody(letter_header &);
	const char *getExtent();
};

class omenrep : public pktreply
{
	// HEADERxy.BBS records:
	struct omenReplyRec {
		unsigned char command;
		unsigned char curboard, moveboard;
		unsigned char msgnumber[2];

		unsigned char tolen;
		char to[35];

		unsigned char sublen;
		char subject[72];

		unsigned char destzone[2], destnet[2], destnode[2];

		unsigned char netattrib;

		unsigned char aliaslen;
		char alias[20];

		unsigned char curhighboard;
		unsigned char movehighboard;
		unsigned char msghighnumber[2];
		char extraspace[4];
	};

	class upl_omen : public upl_base
	{
		omenReplyRec omen_rec;
	 public:
		char subject[73], to[36];
		net_address na;
		long refnum;
		int origArea;
		bool privat;

		bool init(FILE *);
		void output(FILE *);
	};
	bool getRep1(FILE *, upl_omen *, int);
	void getReplies(FILE *);
	void addRep1(FILE *, upl_base *, int);
	void addHeader(FILE *);
	void repFileName();
	const char *repTemplate(bool);
 public:
	omenrep(mmail *, specific_driver *);
	~omenrep();
	area_header *getNextArea();
	letter_header *getNextLetter();
	void enterLetter(letter_header &, const char *, int);
	bool getOffConfig();
	bool makeOffConfig();
};

#endif
