/*
** 1999-03-16 -	Header for the controls module. The use of opaque object-like data structures
**		is spreading rapidly across gentoo, and old proponents of a centralized-data
**		architecture are simply being rolled over. Or something.
*/

#if !defined(CONTROLS_H)
#define	CONTROLS_H

typedef struct _CtrlInfo	CtrlInfo;
typedef struct _CtrlKey		CtrlKey;

CtrlInfo *	ctrl_new(MainInfo *min);
CtrlInfo *	ctrl_new_default(MainInfo *min);
CtrlInfo *	ctrl_copy(CtrlInfo *ctrl);
void		ctrl_destroy(CtrlInfo *ctrl);

CtrlKey *	ctrl_key_add(CtrlInfo *ctrl, const gchar *keyname, const gchar *cmdseq);
CtrlKey *	ctrl_key_add_unique(CtrlInfo *ctrl);
void		ctrl_key_remove(CtrlInfo *ctrl, CtrlKey *key);
void		ctrl_key_remove_by_name(CtrlInfo *ctrl, const gchar *keyname);
void		ctrl_key_remove_all(CtrlInfo *ctrl);
const gchar *	ctrl_key_get_keyname(CtrlKey *key);
const gchar *	ctrl_key_get_cmdseq(CtrlKey *key);
void		ctrl_key_set_keyname(CtrlInfo *ctrl, CtrlKey *key, const gchar *keyname);
void		ctrl_key_set_cmdseq(CtrlInfo *ctrl, CtrlKey *key, const gchar *cmdseq);
gboolean	ctrl_key_has_cmdseq(CtrlInfo *ctrl, CtrlKey *key, const gchar *cmdseq);

void		ctrl_keys_install(CtrlInfo *ctrl, KbdContext *ctx);
void		ctrl_keys_uninstall(CtrlInfo *ctrl, KbdContext *ctx);
void		ctrl_keys_uninstall_all(CtrlInfo *ctrl);
GSList *	ctrl_keys_get_list(CtrlInfo *ctrl);

#endif		/* CONTROLS_H */
