.TH CDRDAO 1 "May 22, 1998"
.SH NAME
cdrdao \- writes audio CD-Rs in disc-at-once mode
.SH SYNOPSIS
.B cdrdao
.RB [ show-toc | read-toc | show-data | read-test | simulate | write ]
.RB [ --device
.IR device ]
.RB [ --driver
.IR driver-id ]
.RB [ --speed
.IR writing-speed ]
.RB [ --eject ]
.RB [ --swap ]
.RI toc-file
.SH DESCRIPTION
.I cdrdao
creates audio CD-Rs in disk-at-once (DAO) mode driven by a description
file called
.I toc-file.
In DAO mode it is possible to create non standard track pre-gaps that
have other lengths than 2 seconds and contain nonzero audio
data. This is for example useful to divide live recordings into
tracks where 2 second gaps would be kind of irritating.

This tool can only produce audio CDs, it is not possible to create
data tracks.
.SH COMMANDS
.TP
The first argument must be one of the following commands:
.TP
.BI show-toc
Print out a summary about what will be written to the CD-R.  
.TP
.BI read-toc
Analyze each track of the inserted audio CD and create a
.I toc-file
that can be used to make a more or less exact copy of the CD. This
command is not completely implemented, yet. Index marks will not be
detected. There is a driver for Plextor CD-ROM readers that is able to
detect pre-gaps. This command does not read out the audio data itself,
use specialized programs like cdda2wav(1) for this purpose.
.TP
.BI show-data
Print out all samples that would be written to the CD-R. Each line
contains the sample number (starting at 0) and the decimal sample
value for the left and right channel. Useful to check if the byte
order of audio files is correct.
.TP
.BI read-test
Checks if all data can be read from the audio files that are defined in
the
.I toc-file.
This will also check the communication with the slave process that is
responsible for writing the audio data to the CD-recorder. Mainly used
for testing.
.TP
.BI simulate
Like
.BI write
but laser stays cold. 
.TP
.BI write
Write the CD-R according to the specifications in the
.I toc-file.
.SH OPTIONS
.TP
.BI \--device " device"
Set the generic SCSI device of the CD-recorder, default is
.I /dev/cdrecorder
which should be a link the actual device.
.TP
.BI \--driver " driver-id"
Force usage of specified driver instead of the automatically
determined driver. Available driver IDs:
.br
cdd2600: Philips CDD2600 writer
.br
plextor: Plextor CD-ROM readers, writing is not supported
.TP
.BI \--speed " value"
Set the writing speed to
.I value.
Default is the highest possible speed.
.TP
.BI \--eject
Eject the CD-R after writing or write simulation.
.TP
.BI \--swap
Swap the byte order of all samples that are send to the CD-recorder.
.SH "TOC FILES"
The
.I toc-file
describes what audio data is written to the CD-R and allows control
over track/index positions, pre-gaps and sub-channel information. It
is a simple text file, use your favorite text editor to create it.

A
.I toc-file
contains an optional header and a sequence of track
specifications. Comments starting with '//' reaching until end of line can be
placed anywhere.

.SS Header
.IP CATALOG\ "ddddddddddddd"
Specifies the optional catalog number of the CD. The string must
contain exactly 13 digits.
.SS Track\ Specification
.IP TRACK\ AUDIO
Starts a new track, the track number is incremented by 1. The length
of a track must be at least 4 seconds. If the audio data length is not
a multiple of the block length (588 samples) it will be padded with zeros.
.LP
The following flags may follow the track start statement. They are
used to set sub-channel information for the current track. Each flag
is optional. If not given the following defaults are used: copy
permitted, no pre emphasis, two channel audio, no ISRC code. 
.IP "[ NO ] COPY"
Sets or clears the copy permitted flag. 
.IP "[ NO ] PRE_EMPHASIS"
Sets or clears the pre emphasis flag.
.IP TWO_CHANNEL_AUDIO
Indicates that track contains two channel audio data.
.IP FOUR_CHANNEL_AUDIO
Indicates that track contains four channel audio data.
.IP ISRC\ "CCOOOYYSSSSS" 
Sets ISRC code of track.
.br
C: country code (upper case letters or digits)
.br
O: owner code (upper case letters or digits)
.br
Y: year (digits)
.br
S: serial number (digits)
.LP
At least one of the following statements must appear to specify the
audio data for the actual track. Lengths and start positions may be
expressed in samples (1/44100 seconds) or in MSF format 'MM:SS:FF' specifying
minutes, seconds and frames (0 <= 'FF' < 75) . A frame contains 588
samples (1/75 second) which is the block size of an audio CD.

If more than one statement is used the track will be composed by
concatenating the audio data in the specified order.
.IP "SILENCE <length>"
Adds zero audio data of specified length to actual track. Useful to create
silent pre-gaps.
.IP FILE\ "<filename>"\ <start>\ [\ <length>\ ]
Adds the audio data of specified file to actual track. It is possible
to select a portion of an audio file with <start> and <length>
which allows non destructive cutting. The first sample of an audio file is
addressed with <start> = 0. If <length> is omitted or set to 0 all
audio data from <start> until the end of file is used.

Audio files may have raw or WAVE format with 16 bits per sample, 44.1
kHz sampling rate, stereo. Raw files must have the layout 'MSBLeft
LSBLeft MSBRight LSBRight ...' (big endian byte order). WAVE files are
expected to have little endian byte order. The option --swap reverses
the expected byte order for all raw and WAVE files. Only filenames
with a ".wav" ending are treated as WAVE files, all other names are
assumed to be raw audio files. Use tools like sox(1) to convert other
file formats to supported formats.

If you are unsure abort the byte order of your audio files try the
command 'show-data'. If the byte order is correct you will see a
sequence of increasing or decreasing numbers for both
channels. Otherwise numbers are jumping between very high and low
values - high volume static.
.IP "START [ MM:SS:FF ]"
Defines the length of the pre-gap (position where index switches from
0 to 1). If the MSF value is omitted or set to '00:00:00' the current
track length is used. If the current track length is not a multiple of
the block length the pre-gap length will be rounded up to next block
boundary.

If no START statement is given the track will not have a pre-gap.
.IP "PREGAP MM:SS:FF"
This is an alternate way to specify a pre-gap with zero audio data. It
may appear before the first SILENCE or FILE statement. Either PREGAP
or START can be used within a track specification. It is equivalent to
the sequence:
.br
  SILENCE MM:SS:FF
.br
  START
.LP
The end of a track specification may contain zero or more index
increment statements:
.IP "INDEX MM:SS:FF"
Increments the index number at given position within the track. The
first statement will increment from 1 to 2. The position is relative
to the real track start, not counting an existing pre-gap.
.SS Examples

Simple track without pre-gap with all audio data from WAVE file
"data.wav":
.nf
.in +.5i
TRACK AUDIO
FILE "data.wav" 0
.in -.5i
.fi

Standard track with two second pre-gap and ISRC code:
.nf
.in +.5i
TRACK AUDIO
ISRC "DEXXX9800001"
PREGAP 0:2:0
FILE "data.wav" 0
.in -.5i
.fi

Track with 10 second pre-gap containing audio data from raw file
"data.cdr":
.nf
.in +.5i
TRACK AUDIO
FILE "data.cdr" 0 
START 0:10:0
.in -.5i
.fi

Composed track with data from different files. Pre-gap data and length
is taken from "pregapdata.wav". The first minute of
"track.cdr" is omitted and two seconds silence are inserted at
\'2:0:0\'. Index will be incremented after 2 and 4 minutes past track start:
.nf
.in +.5i
TRACK AUDIO
FILE "pregapdata.wav" 0 
START
FILE "track.cdr" 1:0:0 1:0:0
SILENCE 0:2:0
FILE "track.cdr" 2:0:0
INDEX 2:0:0
INDEX 4:0:0
.in -.5i
.fi
.SH BUGS
Error conditions are not handled very gracefully. If the program
is terminated during the write/simulation process used IPC
resources will not be released. Use ipcs(8) and ipcrm(8) to delete them.
.SH AUTHOR
Andreas Mueller mueller@daneb.ping.de
.SH SEE ALSO
.BR cdda2wav "(1), " sox "(1), " ipcs "(8), " ipcrm (8)
