/* GNU gettext - internationalization aids
   Copyright (C) 1995 Free Software Foundation, Inc.

   This file was written by Peter Miller <pmiller@agso.gov.au>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _PO_LEX_H
#define _PO_LEX_H

#include <sys/types.h>

typedef struct lex_pos_ty lex_pos_ty;
struct lex_pos_ty
{
  char *file_name;
  size_t line_number;
};


/* Global variables from po-lex.c.  */
extern lex_pos_ty gram_pos;
extern int gram_nerrors;
extern int gram_max_allowed_errors;


void lex_open __P ((const char *__fname));
void lex_close __P ((void));
int po_gram_lex __P ((void));
void po_gram_error __P ((const char *__fmt, ...));
void gram_error_with_loc __P ((const lex_pos_ty *__pos, const char *__fmt,
			       ...));
void po_lex_pass_comments __P ((int));


/* GCC is smart enough to allow optimizations like this.  */
#if __STDC__ && defined __GNUC__ && __GNUC__ >= 2

# define po_gram_error(fmt, args...)					    \
  do {									    \
    error_with_loc (0, 0, gram_pos.file_name, gram_pos.line_number,	    \
		    fmt, ## args);					    \
    if (++gram_nerrors >= gram_max_allowed_errors)			    \
      error (1, 0, _("%s: too many errors, aborting"), gram_pos.file_name); \
  } while (0)


# define gram_error_with_loc(pos, fmt, args...)				    \
  do {									    \
    error_with_loc (0, 0, (pos)->file_name, (pos)->line_number,		    \
		    fmt, ## args);					    \
    if (++gram_nerrors >= gram_max_allowed_errors)			    \
      error (1, 0, _("%s: too many errors, aborting"), (pos)->file_name);   \
  } while (0)
#endif


#endif
