#if defined( Uses_TStringList ) && !defined( __TStringList )
#define __TStringList

class far TStrIndexRec;

const MAXKEYS = 16;

class TStringList : public TObject, public TStreamable
{

public:

    ~TStringList();

    void get( char *dest, ushort key );

private:

    ipstream *ip;
    long basePos;
    short indexSize;
    TStrIndexRec *index;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TStringList( StreamableInit );
    virtual void write( opstream& ) {}
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TStringList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TStringList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TStringList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TStringList* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TStringList

