#if defined( Uses_TScreen ) && !defined( __TScreen )
#define __TScreen

class TDisplay
{

public:

    friend class TView;

    enum videoModes
        {
        smBW80      = 0x0002,
        smCO80      = 0x0003,
        smMono      = 0x0007,
        smFont8x8   = 0x0100
        };

    static void clearScreen( uchar, uchar );

    static ushort getRows();
    static ushort getCols();

    static void setCrtMode( ushort );
    static ushort getCrtMode();
    static void GetCursor(int &x, int &y);
    static void SetCursor(int x, int y);
    static void setCursorType( ushort );
    static ushort getCursorType();
    static void SetPage(uchar);
    static uchar GetPage() { return Page; }

protected:

    TDisplay() { updateIntlChars(); };
    TDisplay( const TDisplay& ) { updateIntlChars(); };
    ~TDisplay() {};

private:

    static void videoInt();
    static void updateIntlChars();

    static ushort * equipment;
    static uchar * crtInfo;
    static uchar * crtRows;
    static uchar Page;

};

class TScreen : public TDisplay
{

public:

    TScreen();
    ~TScreen();

    static void setVideoMode( ushort mode );
    static void clearScreen();

    static ushort startupMode;
    static ushort startupCursor;
    static ushort screenMode;
    static uchar screenWidth;
    static uchar screenHeight;
    static Boolean hiResScreen;
    static Boolean checkSnow;
    static long screenBuffer;
    static ushort cursorLines;

    static void setCrtData();
    static ushort fixCrtMode( ushort );

    static void suspend();
    static void resume();
    static void GetCursor(int &x, int &y);
    static void SetCursor(int x, int y);
    static void setCursorType( ushort );
    static ushort getCursorType();
    static ushort getRows();
    static ushort getCols();


};

#endif  // Uses_TScreen

