/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   class opstream                                                        */
/*                                                                         */
/*   Base class for writing streamable objects                             */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#if defined( Uses_opstream ) && !defined( __opstream )
#define __opstream

#if !defined( __IOSTREAM_H )
#include <iostream.h>
#endif  // __IOSTREAM_H


class far TStreamableClass;

class opstream : virtual public pstream
{

public:

    _Cdecl opstream( streambuf _FAR * );
    _Cdecl ~opstream();

    streampos _Cdecl tellp();
    opstream& _Cdecl seekp( streampos );
    opstream& _Cdecl seekp( streamoff, ios::seek_dir );
    opstream& _Cdecl flush();

    void _Cdecl writeByte( uchar );
    void _Cdecl writeBytes( const void _FAR *, size_t );
    void _Cdecl writeWord( ushort );
    void _Cdecl writeString( const char _FAR * );

    friend opstream& _Cdecl operator << ( opstream&, char );
#ifndef __TURBOC__
    friend opstream& _Cdecl operator << ( opstream&, signed char );
#endif
    friend opstream& _Cdecl operator << ( opstream&, unsigned char );
    friend opstream& _Cdecl operator << ( opstream&, signed short );
    friend opstream& _Cdecl operator << ( opstream&, unsigned short );
    friend opstream& _Cdecl operator << ( opstream&, signed int );
    friend opstream& _Cdecl operator << ( opstream&, unsigned int );
    friend opstream& _Cdecl operator << ( opstream&, signed long );
    friend opstream& _Cdecl operator << ( opstream&, unsigned long );
    friend opstream& _Cdecl operator << ( opstream&, float );
    friend opstream& _Cdecl operator << ( opstream&, double );
    friend opstream& _Cdecl operator << ( opstream&, long double );

    friend opstream& _Cdecl operator << ( opstream&, TStreamable& );
    friend opstream& _Cdecl operator << ( opstream&, TStreamable _FAR * );

protected:

    _Cdecl opstream();

    void _Cdecl writePrefix( const TStreamable& );
    void _Cdecl writeData( TStreamable& );
    void _Cdecl writeSuffix( const TStreamable& );

    P_id_type _Cdecl find( const void _FAR *adr );
    void _Cdecl registerObject( const void _FAR *adr );

private:

    TPWrittenObjects *objs;

};

#endif  // Uses_opstream

