#if defined( Uses_TMonoSelector ) && !defined( __TMonoSelector )
#define __TMonoSelector

class far TRect;
class far TEvent;

class TMonoSelector : public TCluster
{

public:

    TMonoSelector( const TRect& bounds );
    virtual void draw();
    virtual void handleEvent( TEvent& event );
    virtual Boolean mark( int item );
    void newColor();
    virtual void press( int item );
    void movedTo( int item );

private:

    static const char * near button;

    virtual const char *streamableName() const
        { return name; }

protected:

    TMonoSelector( StreamableInit );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TMonoSelector& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TMonoSelector*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TMonoSelector& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TMonoSelector* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TMonoSelector

