#define Uses_TKeys
#define Uses_TEditor
#define Uses_editCommands
#define Uses_TMacro
#define Uses_TMacroRec
#define Uses_TMacroCollection
#define Uses_TStreamableClass
#define Uses_TEvent
#include <tv.h>
#include <string.h>
#include <stdlib.h>

const char * const TMacro::name = "TMacro";

TStreamableClass RMacro( TMacro::name,
			 TMacro::build,
			 __DELTA(TMacro)
			     );

const char * const TMacroRec::name = "TMacroRec";

TStreamableClass RMacroRec( TMacroRec::name,
			 TMacroRec::build,
			 __DELTA(TMacroRec)
			     );

const char * const TMacroCollection::name = "TMacroCollection";

TStreamableClass RMacroCollection( TMacroCollection::name,
			 TMacroCollection::build,
			 __DELTA(TMacroCollection)
			     );

TStreamable *TMacroCollection::build()
{
    return new TMacroCollection( streamableInit );
}

TStreamable *TMacro::build()
{
    return new TMacro( streamableInit );
}

TStreamable *TMacroRec::build()
{
    return new TMacroRec( streamableInit );
}

void TMacroCollection::writeItem(void *item, opstream& os)
{
  os << ((TMacro *)item);
}


void *TMacroCollection::readItem(ipstream& is)
{
  TMacro *macro;
  is >> macro;
  return (void *)macro;
}

void TMacro::write(opstream & os)
{
  int i;
  os.writeString(Macro_Name);
  os << count;
  os << key;
  for (i=0;i<count;i++)
  {
    macs[i]->write(os);
  }
}

void * TMacro::read(ipstream & is)
{
  int i;
  is.readString(Macro_Name,255);
  is >> count;
  is >> key;
  macs = (TMacroRec **)malloc(count*sizeof(TMacroRec *));
  for (i=0;i<count;i++)
  {
    macs[i] = new TMacroRec((ushort)0);
    macs[i]->read(is);
  }
  return this;
}

void TMacroRec::write(opstream & os)
{
  char c=(char)type;
  os << c;
  if (type==Builtin_Command)
  {
    os << data.command;
  }
  else
  if (type==Macro_Command || type==Insert_Command)
  {
    os.writeString(data.Macro_Name);
  }
}

void * TMacroRec::read(ipstream & is)
{
  char c;
  is >> c;
  type = (Macro_Type)c;
  if (type==Builtin_Command)
  {
    is >> data.command;
  }
  else
  if (type==Macro_Command || type==Insert_Command)
  {
    is.readString(data.Macro_Name,255);
  }
  return this;
}

TMacroCollection *macros = new TMacroCollection();

int TMacroCollection::compare(void * key1,void * key2)
{
  return strcmp(((TMacro *)key1)->Macro_Name,((TMacro *)key2)->Macro_Name);
}


void TMacro::handleEvent(TEvent & event,TView * view)
{
  int i;
  if (event.what != evKeyDown) return;
  if (event.keyDown.keyCode != key) return;
  for (i=0;i<count;i++)
  {
    if (macs[i]->type == Builtin_Command)
    {
      event.what = evCommand;
      event.message.command = macs[i]->data.command;
      view->handleEvent(event);
      view->clearEvent(event);
    }
    else
    if (macs[i]->type == Insert_Command)
    {
      event.what = evCommand;
      event.message.command = cmInsertText;
      event.message.infoPtr = macs[i]->data.Macro_Name;
      view->handleEvent(event);
      view->clearEvent(event);
    }
    if (macs[i]->type == Macro_Command)
    {
      ccIndex index;
      TMacro *temp = new TMacro(macs[i]->data.Macro_Name,kbNoKey);
      if (macros->search(temp,index) == True)
      {
	TMacro & macro = *((TMacro *)macros->at(index));
	event.what = evKeyDown;
	event.keyDown.keyCode = macro.key;
	macro.handleEvent(event,view);
      }
      delete temp;
    }
  }
}

TMacro::TMacro(const char * aname,ushort keycode,ushort acommand)
{
  macs = (TMacroRec **)malloc(sizeof(TMacroRec *));
  macs[0] = new TMacroRec(acommand);
  key = keycode;
  Macro_Name = new char[strlen(aname)+1];
  strcpy(Macro_Name,aname);
  count = 1;
}

TMacro::TMacro(const char *aname,ushort keycode)
{
  key = keycode;
  Macro_Name = new char[strlen(aname)+1];
  strcpy(Macro_Name,aname);
  macs = NULL;
  count = 0;
}

void TMacro::insert(TMacroRec *mac)
{
  count++;
  macs = (TMacroRec **)realloc(macs,count*sizeof(TMacroRec *));
  macs[count-1] = mac;
}

TMacro::~TMacro()
{
  delete Macro_Name;
  if (macs)
  {
    int i;
    for (i=0;i<count;i++) delete macs[i];
    free(macs);
  }
}

TMacroRec::~TMacroRec()
{
  if (type == Macro_Command) delete data.Macro_Name;
}

void TMacroCollection::handleEvent(TEvent &event,TView *view)
{
  int i;
  for (i=0;i<count;i++) ((TMacro *)at(i))->handleEvent(event,view);
}

TMacroRec::TMacroRec(ushort acommand)
{
  type = Builtin_Command;
  data.command = acommand;
}

TMacroRec::TMacroRec(const char * name)
{
  type = Macro_Command;
  data.Macro_Name = new char[strlen(name)+1];
  strcpy(data.Macro_Name,name);
}

