// That's the first include because is used to configure the editor.
#include "ceditint.h"

#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TScreen
#include <tv.h>

#ifndef BIOS_KEYBOARD
#include "keyboard.h"
#endif

TEvent near TEventQueue::eventQueue[ eventQSize ] = { {0} };
TEvent *near TEventQueue::eventQHead = TEventQueue::eventQueue;
TEvent *near TEventQueue::eventQTail = TEventQueue::eventQueue;
Boolean near TEventQueue::mouseIntFlag = False;

#include <go32.h>
#include <sys/farptr.h>
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#include <stdio.h>

ushort TICKS(void)
{
  return _farpeekw(_dos_ds,0x46c);
}

ushort near TEventQueue::eventCount = 0;

Boolean near TEventQueue::mouseEvents = False;
Boolean near TEventQueue::mouseReverse = False;
ushort near TEventQueue::doubleDelay = 8;
ushort near TEventQueue::repeatDelay = 8;
ushort near TEventQueue::autoTicks = 0;
ushort near TEventQueue::autoDelay = 0;

MouseEventType near TEventQueue::lastMouse;
MouseEventType near TEventQueue::curMouse;
MouseEventType near TEventQueue::downMouse;
ushort near TEventQueue::downTicks = 0;

TEventQueue::TEventQueue()
{
    resume();
}

static unsigned short rh_getraw_key();
static int rh_kbhit();
unsigned short getshiftstate(void);

static int TEventQueue_suspended = 1;

void TEventQueue::resume()
{
    if (!TEventQueue_suspended) return;
    TEventQueue_suspended = 0;
    mouseEvents = False;
    if( mouse.present() == False )
        mouse.resume();
    if( mouse.present() == False )
        return;
    mouse.getEvent( curMouse );
    lastMouse = curMouse;
    
    mouseEvents = True;
    mouse.setRange( TScreen::getCols()-1, TScreen::getRows()-1 );
}

void TEventQueue::suspend()
{
  if (TEventQueue_suspended) return;
    if (mouse.present() == True) mouse.suspend();
/* I think here is the right place fro clearing the
   buffer */
#ifdef BIOS_KEYBOARD
#if 1
    _farpokel(_dos_ds,0x41A,0x001E001EUL);
#else
   while (rh_kbhit()) rh_getraw_key();
#endif
#else
    clear_keybuf();
#endif
  TEventQueue_suspended = 1;
}

TEventQueue::~TEventQueue()
{
    suspend();
}

void TEventQueue::getMouseEvent( TEvent& ev )
{
    if( mouseEvents == True )
        {

        getMouseState( ev );

        if( ev.mouse.buttons == 0 && lastMouse.buttons != 0 )
            {
            ev.what = evMouseUp;
//            int buttons = lastMouse.buttons;
            lastMouse = ev.mouse;
//            ev.mouse.buttons = buttons;
            return;
            }

        if( ev.mouse.buttons != 0 && lastMouse.buttons == 0 )
            {
            if( ev.mouse.buttons == downMouse.buttons &&
                ev.mouse.where == downMouse.where &&
                ev.what - downTicks <= doubleDelay )
                    ev.mouse.doubleClick = True;

            downMouse = ev.mouse;
            autoTicks = downTicks = ev.what;
            autoDelay = repeatDelay;
            ev.what = evMouseDown;
            lastMouse = ev.mouse;
            return;
            }

        ev.mouse.buttons = lastMouse.buttons;

        if( ev.mouse.where != lastMouse.where )
            {
            ev.what = evMouseMove;
            lastMouse = ev.mouse;
            return;
            }

        if( ev.mouse.buttons != 0 && ev.what - autoTicks > autoDelay )
            {
            autoTicks = ev.what;
            autoDelay = 1;
            ev.what = evMouseAuto;
            lastMouse = ev.mouse;
            return;
            }
        }

    ev.what = evNothing;
}

void TEventQueue::getMouseState( TEvent & ev )
{
//    disable(); this results in a crash in Win31
    if( eventCount == 0 )
        {
        ev.what = TICKS();
        ev.mouse = curMouse;
        }
    else
        {
	ev = *eventQHead;
        if( ++eventQHead >= eventQueue + eventQSize )
            eventQHead = eventQueue;
        eventCount--;
        }
//    enable(); this results in a crash in Win31
    if( mouseReverse != False && ev.mouse.buttons != 0 && ev.mouse.buttons != 3 )
        ev.mouse.buttons ^= 3;
}

int draw_mouse(int,int);
MouseEventType tempMouse;
_go32_dpmi_registers mouseIntRegs;

void TEventQueue::mouseInt()
{
    int x,y;
    tempMouse.buttons = mouseIntRegs.h.bl;
    tempMouse.doubleClick = False;
    x = tempMouse.where.x = (mouseIntRegs.x.cx >> 3) & 0xFF;
    y = tempMouse.where.y = (mouseIntRegs.x.dx >> 3) & 0xFF;
    if (draw_mouse(x,y)) mouseIntFlag = True;
    if( (mouseIntRegs.x.ax & 0x1e) != 0 && eventCount < eventQSize )
        {
        eventQTail->what = TICKS();
        eventQTail->mouse = curMouse;
        if( ++eventQTail >= eventQueue + eventQSize )
            eventQTail = eventQueue;
        eventCount++;
        }

    curMouse = tempMouse;
}

#ifdef BIOS_KEYBOARD

#include <pc.h>

unsigned short getshiftstate(void)
{
  return _farpeekw(_dos_ds,0x417);
}

static unsigned short gkey_shifts_flags;
static uchar gkey_raw_value;

#include <stdio.h>

int convert_num_pad = 0;

static unsigned short rh_getraw_key()
{
  unsigned short key;
#if 0
  REGS r;
  r.h.ah = 0x10;
  INTR(0x16,r);
  key = r.x.ax;
#else
  _farsetsel(_dos_ds);
  unsigned short keybuf_start = _farnspeekw(0x41a);
  key = _farnspeekw(0x400 + keybuf_start);
  keybuf_start += 2;
  if (keybuf_start > 0x3d) keybuf_start = 0x1e;
  _farnspokew(0x41a, keybuf_start);
  // Why is Alt+Backspace different ???
  key = key == 0x0ef0 ? 0x0e00 : key;
  unsigned short sstate = getshiftstate();
#endif
  if (convert_num_pad)
  {
#   define K(_x,_y) case _x: key = _y; break;
    switch (key) { // convert the following keys every time
      K(0xE00D,0x1C0D)  // Enter
      K(0xE00A,0x1C0A)  // Ctrl+Enter
      K(0xA600,0x1C00)  // Alt+Enter
      K(0x4E2B,0x1B2B)  // +
      K(0x9000,0x1B1D)  // ^+
      K(0x4E00,0x1B00)  // A+
      K(0x4A2D,0x352D)  // -
      K(0x4A00,0x3500)  // A-
      K(0x3725,0x1B2A)  // *
      K(0x9600,0x1B1D)  // ^*
      K(0xE02F,0x082F)  // /
    }
    if ((sstate & (32 | 3)) == 3) // numlock disabled and shift pressed
    {
      switch (key) { // convert the keys to the function keys, e.g: '0' to ins
        K(0x5230,0x5200)  // ins
        K(0x532C,0x5300)  // del
        K(0x4F31,0x4F00)  // end
        K(0x5032,0x5000)  // down
        K(0x5133,0x5100)  // pgdwn
        K(0x4B34,0x4B00)  // left
        K(0x4D36,0x4D00)  // right
        K(0x4737,0x4700)  // home
        K(0x4838,0x4800)  // up
        K(0x4939,0x4900)  // pgup
      }
    }
    else if ((sstate & (32 | 3)) == 32) // numlock enabled and no shift
    {
      switch (key) { // convert the scancodes, when numlock is on
                     // to use the digits, '+', '-', '*', '/', ',' and enter
        K(0x5230,0x0B30)  // 0
        K(0x4F31,0x0231)  // 1
        K(0x5032,0x0332)  // 2
        K(0x5133,0x0433)  // 3
        K(0x4B34,0x0534)  // 4
        K(0x4C35,0x0635)  // 5
        K(0x4D36,0x0736)  // 6
        K(0x4737,0x0837)  // 7
        K(0x4838,0x0938)  // 8
        K(0x4939,0x0A39)  // 9
        K(0x532C,0x332C)  // ,
      }
    }
#   undef K
  }
  return key;
}

unsigned short gkey(void)
{
  union
  {
    struct
    {
      unsigned short ax;
    } x;
    struct
    {
      unsigned char al;
      unsigned char ah;
    } h;
  } r;
  r.x.ax = rh_getraw_key();
  gkey_shifts_flags = getshiftstate();
  gkey_raw_value = r.h.ah;
  if (r.h.al == 0xE0 || r.h.al == 0) r.h.al = 0;
  /* Old translation disabled, and re-enabled only to test if make interference */
#define _shifts_flags gkey_shifts_flags
  switch (r.h.ah)
  {
    case 0x39: if (_shifts_flags & 0x0008) r.x.ax = 0x0200; break; // kbAltSpace
    case 0x92: if ((_shifts_flags & 4) && (_shifts_flags & 3))
                 {
                  r.x.ax = 0x0410;
                  break; // kbCtrlShiftIns
                 }
               if (_shifts_flags & 4)
                  r.h.ah = 0x04;
               break; // kbCtrlIns
    case 0x52: if (_shifts_flags & 0x0003) r.h.ah = 0x05;   break; // kbShiftIns
    case 0x93: if ((_shifts_flags & 0x0004) && (_shifts_flags & 0x0003))
                 {
                  r.x.ax = 0x0610;
                  break; // kbCtrlShiftDel
                 }
               if (_shifts_flags & 0x0004)
                  r.h.ah = 0x06;
               break; // kbCtrlDel
    case 0x53: if (_shifts_flags & 0x0003) r.h.ah = 0x07;   break; // kbShiftDel
  }
  return r.x.ax;
}

static int rh_kbhit()
{
#if 0
  return kbhit();
#else
  return (_farpeekw(_dos_ds, 0x41a) != _farpeekw(_dos_ds, 0x41c));
#endif
}

void TEvent::getKeyEvent()
{
  if (!rh_kbhit()) what = evNothing;
  else
  {
    keyDown.keyCode = gkey();
    keyDown.shiftState = gkey_shifts_flags;
    keyDown.raw_scanCode = gkey_raw_value;
    what = evKeyDown;
  }
}

#else

void TEvent::getKeyEvent()
{
  if (!keypressed())
     what = evNothing;
  else
  {
    keyDown.keyCode = readkey();
    what = evKeyDown;
  }
}

#endif

