#define Uses_TDrawBuffer
#include <tv.h>

void TDrawBuffer::moveBuf( ushort indent, const void far *source,
                           ushort attr, ushort count )

{

  if (!count) return;
  int i = 0;
  if (attr)
  {
    attr = attr << 8;
    while (count--)
      data[indent++] = attr | ((const uchar far *)(source))[i++];
    return;
  }
  while (count--) data[indent++] &= 0x00ff;
}

void TDrawBuffer::moveChar( ushort indent, char c, ushort attr, ushort count )
{
  if (!count) return;
  attr = attr << 8;
  if (!c)
  {
    while (count--)
    {
      data[indent] = data[indent] & 0x00ff | attr;
      indent++;
    }
    return;
  }
  if (attr)
  {
    attr |= (uchar)c;
    while (count--) data[indent++] = attr;
    return;
  }
  while (count--)
  {
    data[indent] = data[indent] & 0xff00 | (uchar)c;
    indent++;
  }
}

void TDrawBuffer::moveCStr( ushort indent, const char far *str, ushort attrs )
{
  int i=0;
  uchar bh = attrs >> 8,ah = attrs & 0xff;
  uchar al;
  while (str[i])
  {
    al = str[i++];
    if (al == '~')
    {
      al = ah;
      ah = bh;
      bh = al;
    }
    else
    {
      data[indent++] = ((ushort)(ah)) << 8 | al;
    }
  }
}

void TDrawBuffer::moveStr( ushort indent, const char far *str, ushort attr )
{
  int i=0;
  attr = attr << 8;
  ushort ax;
  while (str[i])
  {
    ax = (uchar)str[i++];
    data[indent++] = attr | ax;
  }
}

