/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#ifndef __RHGDB_H__
#define __RHGDB_H__

const ushort
  cmStep = 300,
  cmTrace = 301,
  cmRun = 302,
  cmReset = 303,
  cmGoto = 304,
  cmOpen = 305,
  cmQUIT = 306,
  cmUserScreen = 307,
  cmWindowList = 308,
  cmToggleBreak = 309,
  cmEvaluate = 310,
  cmAddWatchEntry = 311,
  cmGotoFunction = 312,
  cmBreakPoints = 313,
  cmSaveOptions = 314,
  cmLoadOptions = 315,
  cmSrcDirs = 316,
  cmFunctionList = 317,
  cmPreferences = 318,
  cmViewerAnswer = 319,
  cmGotoLine = 320,
  cmProgArgs = 321,
  cmCallStack = 322,
  cmJumpFunction = 323;
  
extern char *progname;
extern char **files_on_desktop;
extern int files_on_desktop_count;
extern int tabsize;
class TDirList;
extern TDirList *src_dirs;
  
void STEP();
void TRACE();
void RUN();
void RESET();
void GOTO();

void OpenViewer(char *fname,int line,Boolean from_debugger,Boolean only_focus = False);
void CenterCursor();
char *WhereIsCursor(int &line,int &column,char *&bname = NULL);
void ToggleBreak();
void DeleteAllBreakpoints();
void SaveOptions();
void LoadOptions();
void FileOpen();
void SourceDirectories();
void repaint();
void Preferences();
char *RHGDBWordUnderCursor(void);

#endif
