/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#ifndef __IDE_H__
#define __IDE_H__

#include <tv.h>
#include <stdio.h>

#define MODE_INPUT ios::in
#define MODE_OUTPUT ios::out
#define MODE_TRUNCATE ios::trunc
#define MODE_NOCREATE ios::nocreate
#define MODE_BINARY ios::bin

#define PROJECT_EXT ".gpr"
#define DESKTOP_EXT ".gdt"

#define OLD_PROJECT_IDENT "__gcc_project-file__"
#define PROJECT_IDENT "__RHIDE_project-file__\x1A"
#define DESKTOP_IDENT "__RHIDE_desktop-file__\x1A"

#define Options (*(Project.options))

#define MEMAVAIL
#define HEAPCHECK

#define AINSERT(s) \
do {\
  char *__tmp__;\
  string_dup(__tmp__,(s));\
  args.insert(__tmp__);\
} while (0)

class TSCollection;

/* module idemain.cc */
class IDE;
extern IDE *App;
extern int global_argc;
extern char **global_argv;
extern char *RHIDE_DIR;
extern char *RHIDE_NAME;
extern char *RHIDE_EXT;
extern int external_program_executed;
void Repaint();
class TProject;
void SetMainTargetName(char *,TProject *_prj = NULL);
int SaveAll();
extern unsigned long hasmodified;
extern int c_words_changed;
extern int gpc_words_changed;
extern int user_words_changed;
char *WUC();

/* module ideopt.cc */
class TDirList;
class TParamList;
class TDependency;
class TParamList;

void InitOptions();
void EditDirList(TDirList *dirlist,const char *title,int hist_id);
ushort EditParamList(TParamList *paramlist,const char *title,int hist_id);
void AddArg(const char * option);

void OptimizationFlags();
void DebugFlags();
void WarningFlags();
void CFlags();
void CXXFlags();
void PascalFlags();

void Libraries(void);
void AddLibraries(char *&);
void LinkerOptions(void);
void CompilerOptions(void);
void Preferences();

void EditReserved();
void EditGPCReserved();
void EditCFlags();
void EditCXXFlags();
void EditDebugFlags();
void EditWarnFlags();
void EditOptFlags();
void EditPascalFlags();
void EditUserWords();

/* module idegcc.cc */
long TimeOfFile(const char *fname,Boolean do_update,Boolean is_full_name = False);
Boolean Make(Boolean force_messages = True);
Boolean Build(void);
Boolean RunMainTarget(void);
class TDependency;
Boolean Compile(TDependency *_dep = NULL);
int RunProgram(const char *cmd,
                   Boolean redir_stderr,Boolean redir_stdout,
		   Boolean SwitchToUser = False);
void ClearFileHash();

/* module idecomp.cc */
class TDependency;
Boolean compile_dep(TDependency *);
extern int already_maked;

/* module ideprj.cc */
class TProject;
class TProjectWindow;
class TListBox;
Boolean OpenProject(const char *);
void SaveProject();
void CloseProject();
void SaveOptions();
void LoadOptions();
void ShowProject(void);
void HideProjectWindow(void);
void AddProjectItem(void);
ccIndex AddProjectItem(char *name);
void DelProjectItem(void);
extern TProjectWindow *project_window;
void LocalOptions();
void ShowIncludes();
Boolean PushProject(char *directory,char *prjname);
void PopProject();
void ResetProjectStack();
void ClearDependencies();
void MakeClear();
void AddToStack();
int OpenFromStack();
void RemoveFromStack();
extern int PRJSTACKCOUNT;
extern char *project_directory;
class TEditWindow;
void SetGlobalEditorOptions(TEditWindow *);
void SetGlobalEditorOptions();
void SetProjectScreenMode();
void EnableShadows();
void DisableShadows();

/* module ideio.cc */
char * open_stderr(void);
char * open_stdout(void);
void close_stderr(void);
void close_stdout(void);
extern char * cpp_outname;
extern char * cpp_errname;

/* module ideutil.cc */
Boolean FindFile(const char * name,TDirList * list,char * & full_name,Boolean uselist=True);
Boolean FindFile(const char * name,char * & full_name);
void ClearFindCache();
void AbsToRelPath(char *ref_path,char * & ret);
extern int debug_dependencies;
extern int debug_commands;
extern int debug_tempfiles;
extern int debug_files;

/* module idemsg.cc */
class TMsgCollection;
class TDialog;
void ShowMessages(TMsgCollection *msgs,Boolean remove_old);
extern TDialog *msg_window;

/* module idedefault.cc */
void DefaultOptFlags();
void DefaultDebugFlags();
void DefaultWarnFlags();
void DefaultCXXFlags();
void DefaultCFlags();
void DefaultPascalFlags();
void DefaultReservedWords();
void DefaultGPCReservedWords();
void DefaultUserWords();

/* module idecolors.cc */
void Colors();

/* module idehints.cc */
const char * IDEHint(unsigned short);

/*module ideformatline.cc */
class TEditor;
void SyntaxFormatLine_C(TEditor *,void *,uint32,int,ushort,uint32);
void SyntaxFormatLine_Pascal(TEditor *,void *,uint32,int,ushort,uint32);

/* module ideresource.cc */
Boolean InitResource();
void CloseResource();
class TMenuBar;
class TRect;
class TFlagCollection;
TFlagCollection * GetOptFlags();
TFlagCollection * GetWarnFlags();
TFlagCollection * GetDebugFlags();
TFlagCollection * GetCXXFlags();
TFlagCollection * GetCFlags();
class TStringCollection;
TStringCollection * GetReservedWords();

/* module IDEExtern.cc */
void FSDB();
void GREP();
void GDB();

/* module IDEHelp.cc */
class TIDEInfWindow;
extern TIDEInfWindow *InfWindow;
void Help();
void Help(ushort);
void HelpIndex();
void ContextHelp(ushort);
void SyntaxHelp(const char *,const char *fname = "libc.inf");
class TRect;
extern TRect InfRec;

/* module IDEDebug.cc */
void STEP();
void TRACE();
void GOTO();
void RESET();
void CONTINUE();
int DEBUGGER_STARTED();
void InitDebuggerInterface();
void ToggleBreak();

/* module idemak.cc */
Boolean ReadProject(const char *);
void WriteMake(char *outname=NULL,int argc=0,char *arg[]=NULL);
extern TProject *project;
#define Project (*project)
extern char *project_directory;
extern char *project_name;
extern int recursive_make;

/* module idespec.cc */
class TDependency;
char *BuildCompiler(TDependency *dep,char *spec);
char *GetCompilerSpec(TDependency *dep,Boolean & is_user);
void WriteSpecData(FILE *);

/* module ideversi.cc */
extern char IDEVersion[];


#ifdef Uses_IDEConst
#include <ideconst.h>
#endif

typedef struct {
  unsigned all_deps:1;
  unsigned create_backup_files:1;
  unsigned show_syntax:1;
  unsigned use_dual_display:1;
  unsigned autoindent:1;
  unsigned overwrite:1;
  unsigned show_stderr:1;
  unsigned show_stdout:1;
  unsigned show_doing:1;
  unsigned show_mem:1;
  unsigned no_file_cache:1;
  unsigned c_autoindent:1;
  unsigned use_tabs:1;
  unsigned no_stdinc:1;
  unsigned no_stdlib:1;
  unsigned for_profile:1;
} ide_options;

#define IDE_OPTIONS (*((ide_options*)&(Options.debug_level)))
#define AllDeps (IDE_OPTIONS.all_deps)
#define CreateBackupFiles (IDE_OPTIONS.create_backup_files)
#define ShowSyntax (IDE_OPTIONS.show_syntax)
#define UseDualDisplay (IDE_OPTIONS.use_dual_display)
#define AutoIndent (IDE_OPTIONS.autoindent)
#define OverWrite (IDE_OPTIONS.overwrite)
#define ShowStderr (IDE_OPTIONS.show_stderr)
#define ShowStdout (IDE_OPTIONS.show_stdout)
#define ShowWhatDoing (IDE_OPTIONS.show_doing)
#define ShowMem (IDE_OPTIONS.show_mem)
#define NoFileCache (IDE_OPTIONS.no_file_cache)
#define CAutoIndent (IDE_OPTIONS.c_autoindent)
#define UseRealTabs (IDE_OPTIONS.use_tabs)

typedef struct
{
  unsigned no_persistent_blocks:1;
  unsigned column_cursor:1;
  unsigned row_cursor:1;
  unsigned intense_mode:1;
  unsigned verbose_gdb_commands:1;
  unsigned no_shadows:1;
  unsigned transparent_blocks:1;
  unsigned save_text_palette:1;
  unsigned save_project_only_when_closing:1;
  unsigned dummy:23;
} ide_options1;

#define IDE_OPTIONS1 (*((ide_options1*)&(Project.options1)))
#define NoPersistentBlocks (IDE_OPTIONS1.no_persistent_blocks)
#define ShowColumnCursor (IDE_OPTIONS1.column_cursor)
#define ShowRowCursor (IDE_OPTIONS1.row_cursor)
#define IntenseMode (IDE_OPTIONS1.intense_mode)
#define VerboseGDB (IDE_OPTIONS1.verbose_gdb_commands)
#define NoShadows (IDE_OPTIONS1.no_shadows)
#define TransparentBlocks (IDE_OPTIONS1.transparent_blocks)
#define SaveTextPalette (IDE_OPTIONS1.save_text_palette)
#define SaveProjectOnlyWhenClosing (IDE_OPTIONS1.save_project_only_when_closing)

#define NoStdInc (IDE_OPTIONS.no_stdinc)
#define NoStdLib (IDE_OPTIONS.no_stdlib)
#define ForProfile (IDE_OPTIONS.for_profile)

#define CReservedWords (Options.reserved)
#define GPCReservedWords (Options.gpc_reserved)
#define RHIDEUserWords (Options.user_words)

#define TabSize (Project.tabsize)

#include <intl.h>

#endif
