# Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details 
# This file is part of RHIDE. 
.SUFFIXES: .mak .gpr

ifeq ($(strip $(list_file)),)
list_file=list
endif

ifeq ($(strip $(po_list)),)
po_list=po_list
endif

ifeq ($(strip $(logfile)),)
logfile=logfile
endif

prefix=$(DJDIR)
locale_dir=$(prefix)/data/locale
PACKAGE=rhide
FILE_VERSION=11
DIR_VERSION=-1.1
CURRENT_LANGUAGES=da de es fi fr it nl pt sv
LANGUAGES=$(CURRENT_LANGUAGES)
FUTURE_LANGUAGES=ee pl ru # they were not ready when releasing RHIDE

empty=
space=$(empty) $(empty)
top_dir:=$(strip $(subst $(RHIDESRC),,$(srcdir)))
ifeq ($(top_dir),)
top_dir:=.
else
top_dir:=$(subst /, ,$(top_dir))
top_dir:=$(patsubst %,../,$(top_dir))
top_dir:=$(subst $(space),,$(top_dir))
top_dir:=$(patsubst %/,%,$(top_dir))
endif

obj_dir:=$(shell cd)

gpr2mak:=$(wildcard $(top_dir)/gpr2mak.exe)

ifeq ($(strip $(gpr2mak)),)
gpr2mak:=$(wildcard $(DJDIR)/bin/gpr2mak.exe)
endif

ifeq ($(strip $(prefix)),)
prefix=$(DJDIR)
endif

FLAGS_TO_PASS=\
	CFLAGS=$(CFLAGS) \
	RHIDESRC=$(RHIDESRC)

%.sub: makefile
	$(MAKE) -C $* $(FLAGS_TO_PASS) SUBDIR_TARGET=$(SUBDIR_TARGET) $(SUBDIR_TARGET)

subdir_do: $(addsuffix .sub,$(subdirs))

copy_src_files::
ifneq ($(src_files),)
	@echo Copying files from $(srcdir)
	@cp -p $(addprefix $(srcdir)/,$(src_files)) $(prefix)
	@echo $(addprefix $(list_prefix),$(src_files)) > $(list_file)
endif

po_list::
	echo $(addprefix $(po_prefix),$(po_files)) > $(po_list)
ifneq ($(strip $(po_subdirs)),)
# special case for po_subdirs=..
ifeq ($(strip $(po_subdirs)),..)
this_dir:=$(notdir $(shell pwd))
po_list::
	$(MAKE) -C .. $(FLAGS_TO_PASS) po_list=$(this_dir)/$(this_dir).pst \
	  po_prefix=$(po_prefix)../ po_list
	cat $(this_dir).pst >> $(po_list)
	rm $(this_dir).pst
else
po_sub_files=$(addsuffix .pst,$(po_subdirs))
po_list:: $(po_sub_files)
	cat $(po_sub_files) >> $(po_list)
	rm $(po_sub_files)
endif
endif

%.pst: makefile
	$(MAKE) -C $* $(FLAGS_TO_PASS) po_list=../$@ \
	  po_prefix=$(po_prefix)$*/ po_list

update__srcdir:: $(update_files)
ifeq ($(strip $(update_files)),)
	@echo Nothing to do for updating $(srcdir)
else
ifeq ($(obj_dir),$(srcdir))
	@echo Nothing to do for updating $(srcdir)
else
	cp -f $(update_files) $(srcdir)
endif
endif

ifneq ($(strip $(subdirs)),)
copy_src_files:: $(addsuffix .cpy,$(subdirs))

update__srcdir:: $(addsuffix .sub,$(subdirs))
endif

%.cpy: makefile
	@-mkdir $(prefix)/$*
	@$(MAKE) -C $* $(FLAGS_TO_PASS) prefix=../$(prefix)/$* \
	  --no-print-directory \
	  list_file=../$@ list_prefix=$(list_prefix)$*/ copy_src_files
	@cat $@ >> $(list_file)
	@-rm $@

%.mo: %.po
	-$(msgfmt) -o $@ $(wildcard $(addsuffix /$*.po*,$(SLIBDIRS))) $<

ifneq ($(strip $(gpr2mak)),)
%.mak: %.gpr
	$(gpr2mak) -d -r- -o - $< \
	  | sed -e 's,	$(DJDIR),	$$(DJDIR),g' \
	        -e 's,	$(RHIDESRC),	$$(RHIDESRC),g' > $@
endif

ifneq ($(strip $(project)),)
-include $(addsuffix .mak,$(project))
endif

check.objdir:
ifeq ($(strip $(objdir)),)
	@echo ERROR: You must set the variable $$(objdir)
	@redir -e nul -o nul
else
ifeq ($(word 2,$(subst :, ,$(objdir))),)
	@echo ERROR: You must set the variable $$(objdir) to an absolute directory
	@redir -e nul -o nul
endif
endif

create.objdir::
	@echo Configuring $(objdir) ..
	-mkdir $(objdir)

%.cfo: makefile
	$(MAKE) -C $* $(FLAGS_TO_PASS) objdir=$(objdir)/$* config

.PHONY: config

ifeq ($(wildcard $(top_dir)/rhide.src),)
config::
	@echo ERROR: The target 'config.objdir' is valid only in the source tree
	@redir -e nul -o nul
else
config:: check.objdir create.objdir
	update $(srcdir)/makefile $(objdir)/makefile
ifneq ($(cfg_files),)
	cp $(addprefix $(srcdir)/,$(cfg_files)) $(objdir)
endif
ifneq ($(project),)
	cp $(addprefix $(srcdir)/,$(addsuffix .gpr,$(project))) $(objdir)
	cp $(addprefix $(srcdir)/,$(addsuffix .mak,$(project))) $(objdir)
endif
ifneq ($(obj_subdirs),)
config:: $(addsuffix .cfo,$(obj_subdirs))
endif
endif
