/* This source code is taken from Christian Domp <chrisd@europeonline.com> */
#include <stdio.h>
#include <pc.h>
#include <dpmi.h>
#include <sys/farptr.h>
#include <dos.h>
#include <go32.h>

#define NUM_TWEAKED_MODES 6
#define TW80X30		0
#define TW80X34		1
#define TW90X30		2
#define TW90X34		3
#define TW94X30		4
#define TW94X34		5

static unsigned short width[]={80,80,90,90,94,94};
static unsigned short height[]={30,34,30,34,30,34};

static unsigned short ttweaks[][16] = {
    {   /* 80x30 */
    0x0c11,0x5f00,0x4f01,0x5002,0x8203,0x5504,0x8105,0x0b06,
    0x3e07,0x4f09,0xea10,0x8c11,0xdf12,0x2813,0xe715,0x0416
    },
    {   /* 80x34 */
    0x0c11,0x5f00,0x4f01,0x5002,0x8203,0x5504,0x8105,0x0b06,
    0x3e07,0x4d09,0xea10,0x8c11,0xdf12,0x2813,0xe715,0x0416
    },
    {   /* 90x30 */
    0x0c11,0x6d00,0x5901,0x5a02,0x9003,0x6004,0x8b05,0x0b06,
    0x3e07,0x4f09,0xea10,0x8c11,0xdf12,0x2d13,0xe715,0x0416
    },
    {   /* 90x34 */
    0x0c11,0x6d00,0x5901,0x5a02,0x9003,0x6004,0x8b05,0x0b06,
    0x3e07,0x4d09,0xea10,0x8c11,0xdf12,0x2d13,0xe715,0x0416
    },
    {   /* 94x30 */
    0x0c11,0x6c00,0x5d01,0x5e02,0x8f03,0x6204,0x8e05,0x0b06,
    0x3e07,0x4f09,0xea10,0x8c11,0xdf12,0x2f13,0xe715,0x0416
    },
    {   /* 94x34 */
    0x0c11,0x6c00,0x5d01,0x5e02,0x8f03,0x6204,0x8e05,0x0b06,
    0x3e07,0x4d09,0xea10,0x8c11,0xdf12,0x2f13,0xe715,0x0416
    }
};

int set_tweaked_text(int tmode)
{
  __dpmi_regs regs;
  int i;
  volatile int junk;
  
  if(tmode>=NUM_TWEAKED_MODES) return -1;
  
  regs.x.ax = 0x3 | 0x80; // do not clear the screen
  __dpmi_int(0x10, &regs);

  /* load 8x14 font for 34 line modes */
  if(height[tmode] == 34) {
    regs.x.ax = 0x1111;
    regs.h.bl = 0;
    __dpmi_int(0x10, &regs);
  }
  /* wait for vertical retrace */
  while((inportb(0x3da) & 8) != 0);
  while((inportb(0x3da) & 8) == 0);
  disable();
  outportb(0x3c2,0xe7);
  /* set sequencer clocking mode */
  outportw(0x3c4,0x101);
  /* reset data flip-flop to address mode */
  junk=inportw(0x3da);
  outportb(0x3c0,0x30);
  /* set mode control register */
  outportb(0x3c0,0x04);
  outportb(0x3c0,0x33);
  /* set horizontal pixel pan */
  outportb(0x3c0,0x00);
  for(i = 0; i < 16; i++) {
    outportw(0x3d4,ttweaks[tmode][i]);
  }
  _farsetsel(_dos_ds);
  /* update BIOS data area */
  _farnspokew(0x44a,width[tmode]);
  _farnspokeb(0x484,height[tmode] - 1);
  _farnspokew(0x44c,width[tmode] * height[tmode] * 2);
  enable();
  return 0;
}

#ifdef TEST
int main(void)
{
  int i,mode;

  for(mode=0;mode<NUM_TWEAKED_MODES;mode++) {
    set_tweaked_text(mode);
    printf("\n%d x %d mode\n",ScreenCols(),ScreenRows());
    for(i=0;i<10;i++) printf("1234567890");
    printf("\n");
    getkey();
    for(i=50;i>0;i--) printf("%d\n",i);
    getkey();
  }
  return 0;
}
#endif

