/*----------------------------------------------------------*/
/*                                                          */
/*   Turbo Vision 1.0                                       */
/*   Copyright (c) 1991 by Borland International            */
/*                                                          */
/*   Turbo Vision TVEDIT header file                        */
/*----------------------------------------------------------*/

class TMenuBar;
class TStatusLine;
class TEditWindow;
class TDialog;

#ifndef RHIDE
const
  cmOpen       = 100,
  cmNew        = 101,
  cmChangeDrct = 102,
  cmDosShell   = 103,
  cmCalculator = 104,
  cmShowClip   = 105;
#endif

const cmInfView = 106,
      cmListWin = 107,
      cmLastHelp= 108,
      cmUserScreen = 109;
const cmGo     = 900,
      cmDelete = 901;
const hcListWin=0x2101;


class TEditorApp : public TApplication
{

public:

    TEditorApp();

    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );
    virtual void outOfMemory();
    TPalette& TEditorApp::getPalette() const;
    void retrieveDesktop();
    void saveDesktop();
    void storeDesktop(fpstream& s);
    void loadDesktop(fpstream& s);
    TCEditWindow *openEditor( const char *fileName, Boolean visible );
    void TEditorApp::createClipBoard(void);
    void executeCalc(void);
    void ShowUserScreen(void);

private:

    void fileOpen();
    void fileNew();
    void changeDir();
    void dosShell();
    void showClip();
    void tile();
    void cascade();
};

extern TCEditWindow *clipWindow;

ushort execDialog( TDialog *d, void *data );
TDialog *createFindDialog();
TDialog *createReplaceDialog();
TDialog *createGotoLineDialog();
TDialog *createSetLocalOptions();
TDialog *createSetGlobalOptions();
ushort doEditDialog( int dialog, ... );

