#if defined( Uses_TDeskTop )  && !defined( __TDeskTop )
#define __TDeskTop

class far TBackground;
class far TRect;
class far TEvent;

class TDeskInit
{

public:

    TDeskInit( TBackground *(*cBackground)( TRect ) );

protected:

    TBackground *(*createBackground)( TRect );

};

class TDeskTop : public TGroup, public virtual TDeskInit
{

public:

    TDeskTop( const TRect& );

    void cascade( const TRect& );
    virtual void handleEvent( TEvent& );
    static TBackground *initBackground( TRect );
    void tile( const TRect& );
    virtual void tileError();
    virtual void shutDown();

protected:

    TBackground *background;

private:

    static const char near defaultBkgrnd;
    
    virtual const char *streamableName() const
        { return name; }

protected:

    TDeskTop( StreamableInit );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TDeskTop& cl )
    { return is >> (TStreamable&)(TGroup&)cl; }
inline ipstream& operator >> ( ipstream& is, TDeskTop*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDeskTop& cl )
    { return os << (TStreamable&)(TGroup&)cl; }
inline opstream& operator << ( opstream& os, TDeskTop* cl )
    { return os << (TStreamable *)(TGroup *)cl; }

#endif

