#define Uses_TSystemError
#define Uses_TEventQueue
#define Uses_TScreen
#define Uses_TObject
#define Uses_TMouse
#define Uses_TApplication
#include <tv.h>

#include <stdio.h>

static TScreen tsc;
TMouse TEventQueue::mouse;
static TEventQueue teq;
// static TSystemError sysErr;

#ifdef __DJGPP__
#include <dpmi.h>

#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)

#define AX r.x.ax
#define BX r.x.bx
#define CX r.x.cx
#define DX r.x.dx
#define ES r.x.es

static int mouse_buffer_segment;
static int mouse_buffer_selector;
static int mouse_buffer_size;
static int mouse_buffer_allocated = 0;

#endif

static void restore_mouse_state()
{
#ifdef __DJGPP__
  REGS r;
  if (mouse_buffer_allocated)
  {
    AX = 0x0017;
    BX = mouse_buffer_size;
    ES = mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
  }
#endif
}

static void save_mouse_state()
{
#ifdef __DJGPP__
  REGS r;
  if (!mouse_buffer_allocated)
  {
    AX = 0x0015;
    INTR(0x33,r);
    mouse_buffer_size = BX;
    mouse_buffer_segment = __dpmi_allocate_dos_memory(
                             (mouse_buffer_size+15)>>4,
                             &mouse_buffer_selector);
    if (mouse_buffer_segment != -1)
      mouse_buffer_allocated = 1;
  }
  if (mouse_buffer_allocated)
  {
    AX = 0x0016;
    BX = mouse_buffer_size;
    ES = mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
  }
#endif
}

#ifdef __DJGPP__
static int my_mouse_buffer_segment;
static int my_mouse_buffer_selector;
static int my_mouse_buffer_size;
static int my_mouse_buffer_allocated = 0;
#endif

static void restore_my_mouse_state()
{
#ifdef __DJGPP__
  REGS r;
  if (my_mouse_buffer_allocated)
  {
    AX = 0x0017;
    BX = my_mouse_buffer_size;
    ES = my_mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
  }
#endif
}

static void save_my_mouse_state()
{
#ifdef __DJGPP__
  REGS r;
  if (!my_mouse_buffer_allocated)
  {
    AX = 0x0015;
    INTR(0x33,r);
    my_mouse_buffer_size = BX;
    my_mouse_buffer_segment = __dpmi_allocate_dos_memory(
                             (my_mouse_buffer_size+15)>>4,
                             &my_mouse_buffer_selector);
    if (my_mouse_buffer_segment != -1)
      my_mouse_buffer_allocated = 1;
  }
  if (my_mouse_buffer_allocated)
  {
    AX = 0x0016;
    BX = my_mouse_buffer_size;
    ES = my_mouse_buffer_segment;
    DX = 0;
    INTR(0x33,r);
  }
#endif
}

void TApplication::resume()
{
  save_mouse_state();
  TScreen::resume();
  TEventQueue::resume();
  TSystemError::resume();
  restore_my_mouse_state();
}

void TApplication::suspend()
{
  save_my_mouse_state();
  TSystemError::suspend();
  TEventQueue::suspend();
  TScreen::suspend();
  restore_mouse_state();
}

void initHistory();
void doneHistory();

TApplication::TApplication() :
    TProgInit( &TApplication::initStatusLine,
                  &TApplication::initMenuBar,
                  &TApplication::initDeskTop
                )
{
    initHistory();
//    resume();
//    TEventQueue::resume();
    TSystemError::resume();
}

TApplication::~TApplication()
{
    doneHistory();
//    suspend();
    TSystemError::suspend();
}

