#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <dir.h>
#include <sys/stat.h>

static char _static_buffer[2048]; // this should be enough

void string_dup(char * & dest,const char * src)
{
  if (!src || !*src)
  {
    dest = (char *)xmalloc(1);
    *dest = 0;
  }
  else dest = strdup(src);
}

void string_cat(char * & dest,const char * src)
{
  if (!dest)
  {
    string_dup(dest,src);
    return;
  }
  int l1 = strlen(dest), l2 = strlen(src);
  dest = (char *)xrealloc(dest,l1+l2+1);
  memcpy(dest+l1,src,l2+1);
}

void string_free(char * & dest)
{
  if (dest) delete dest;
  dest = NULL;
}

void string_down(char * dest)
{
  if (!dest) return;
  while (*dest) *dest = tolower(*dest++);
}

void BaseName(const char * name,char * & bname,Boolean with_suffix)
{
  char *_bname = _static_buffer;
  char *ext = (with_suffix == True) ? _static_buffer + 256 : NULL;
  fnsplit(name,NULL,NULL,_bname,ext);
  string_dup(bname,_bname);
  if (with_suffix == True) string_cat(bname,ext);
}

void BaseName(char *name,Boolean with_suffix)
{
  char *_name = _static_buffer;
  char *ext = (with_suffix == True) ? _static_buffer + 256 : NULL;
  strcpy(_name,name);
  fnsplit(_name,NULL,NULL,name,ext);
  if (with_suffix == True) strcat(name,ext);
}

void BackslashToSlash(char *name)
{
  char *tmp;
  if (!name || !*name) return;
  while ((tmp = strchr(name,'\\')) != NULL) *tmp = '/';
}

void FExpand(char * & name,Boolean new_alloc)
{
  char *fname = _static_buffer;
  _fixpath(name,fname);
  if (new_alloc == True)
  {
    string_free(name);
    string_dup(name,fname);
  }
  else strcpy(name,fname);
}

void split_fname(const char * filename,char * & dir,char * & file,char * & ext)
{
  char *drive = _static_buffer;
  char *_dir  = _static_buffer + 3;
  char *_name = _static_buffer + 3 + 512;
  char *_ext  = _static_buffer + 3 + 512 + 512;
  fnsplit(filename,drive,_dir,_name,_ext);
  string_dup(dir,drive);
  string_cat(dir,_dir);
  string_dup(file,_name);
  string_dup(ext,_ext);
}

char *expand_variables(char **x)
{
  char *var,*var_end,*env;
  char *buffer;
  char *xptr,*bptr;
  if (!strchr(*x,'$')) return *x;
  buffer = _static_buffer;
  xptr = *x;
  bptr = buffer;
  while (*xptr)
  {
    if (*xptr == '$' && xptr[1] == '(')
    {
      char old;
      var = xptr+2;
      var_end = var+1;
      while (*var_end && *var_end != ')') var_end++;
      old = *var_end;
      *var_end = 0;
      env = getenv(var);
      *var_end = old;
      if (env)
      {
        while (*env)
        {
          *bptr++ = *env++;
        }
        xptr = var_end+1;
        continue;
      }
      *bptr++ = *xptr++;
    }
    else
    {
      *bptr++ = *xptr++;
    }
  }
  *bptr = 0;
  string_free(*x);
  string_dup(*x,buffer);
  return *x;
}

