#if !defined( tvutilFunctions__ )
#define tvutilFunctions__

class TWindow;
void AddWindow(TWindow *,TWindow **ref = NULL,Boolean before = False);
void RemoveWindow(TWindow *);
void UpdateWindow(TWindow *window);
void ShowWindowList(const char *);

class TSCollection;
extern TSCollection *windows;
#define DESKTOPWINDOW(index) (((DeskTopWindow *)windows->at(index))->window)

void string_dup(char * &,const char *);
void string_cat(char * &,const char *);
void string_free(char * &);
void string_down(char *);
char *expand_variables(char **);
void BackslashToSlash(char * name);
void BaseName(const char * name,char * & bname,Boolean with_suffix = True);
void BaseName(char *name,Boolean with_suffix = True);
void FExpand(char * & name,Boolean new_alloc = True);
void split_fname(const char * filename,char * & dir,char * & file,char * & ext);

class TParamList;
ushort editParamList(TParamList *paramlist, const char *title,int hist_id);

class TDirList;
void editDirList(TDirList *dirlist, const char *title,int hist_id);

class TRect;
ushort BigmessageBox( const char *msg, ushort aOptions );
ushort BigmessageBox( ushort aOptions, const char *fmt, ... );
ushort BiginputBox( const char *Title, const char *aLabel, char *s, int limit );
ushort HistinputBox( const char *Title, const char *aLabel, char *s,
                     int limit, int hist_id );
class TValidator;
ushort ValidInputBox( const char *Title, const char *aLabel, char *s,
                      int limit, TValidator * validator);

extern int hist_id_count;
extern int *hist_ids;
void InitHistoryID(int);
void ClearHistoryIDs();
class ipstream;
void LoadHistoryIDs(ipstream &);
class opstream;
void SaveHistoryIDs(opstream &);

#endif
