/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TRect
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TPalette
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TEditor

#include <rhide.h>
class _TColorItem : public TColorItem
{
public:
    _TColorItem( const char *nm, uchar idx);
};

_TColorItem::_TColorItem(const char *nm,uchar idx) :
  TColorItem(_(nm),idx)
{
}

static TPalette *temp_pal = NULL;

static TColorGroup & windows_colors(char *name,int base)
{
  return
    *new TColorGroup(name)
      +*new _TColorItem(__("Frame disabled"),  base)
      +*new _TColorItem(__("Frame"),  base+0x01)
      +*new _TColorItem(__("Frame icons"), base+0x02)
      +*new _TColorItem(__("Scroll bar page"), base+0x03)
      +*new _TColorItem(__("Scroll bar icons"), base+0x04)
      +*new _TColorItem(__("Static text"), base+0x05)
      +*new _TColorItem(__("Selected text"), base+0x06)
#if 0
      +*new _TColorItem(__("reserved"), base+0x07)
#endif
      ;
}

static TColorGroup & editor_colors(char *name,int base)
{
  return
    *new TColorGroup(name)
      +*new _TColorItem(__("Frame disabled"), base)
      +*new _TColorItem(__("Frame/background"), base+0x01)
      +*new _TColorItem(__("Frame icons"), base+0x02)
      +*new _TColorItem(__("Scroll bar page"), base+0x03)
      +*new _TColorItem(__("Scroll bar icons"), base+0x04)
      +*new _TColorItem(__("normal text"), base+0x05)
      +*new _TColorItem(__("marked text"), base+0x06)
      +*new _TColorItem(__("comment"), base+0x07)
      +*new _TColorItem(__("reserved word"), base+0x08)
      +*new _TColorItem(__("identifier"), base+0x09)
      +*new _TColorItem(__("symbol"), base+0x0A)
      +*new _TColorItem(__("string"), base+0x0B)
      +*new _TColorItem(__("integer"), base+0x0C)
      +*new _TColorItem(__("float"), base+0x0D)
      +*new _TColorItem(__("octal"), base+0x0E)
      +*new _TColorItem(__("hex"), base+0x0F)
      +*new _TColorItem(__("character"), base+0x10)
      +*new _TColorItem(__("preprocessor"), base+0x11)
      +*new _TColorItem(__("illegal char"), base+0x12)
      +*new _TColorItem(__("user defined words"), base+0x13)
      +*new _TColorItem(__("CPU line"), base+0x14)
      +*new _TColorItem(__("Breakpoint"), base+0x15)
      +*new _TColorItem(__("symbol2"), base+0x16)
      +*new _TColorItem(__("Cross cursor"), base+0x17)
      +*new _TColorItem(__("editor statusline"), base+0x18)
      +*new _TColorItem(__("parens matching"), base+0x19)
      +*new _TColorItem(__("rectangle block"), base+0x1A)
      ;
}

static TColorDialog *GetColorDialog()
{
  TColorDialog *c;
  TColorGroup &group0 =
    *new TColorGroup(_("Desktop"))
      +*new _TColorItem(__("Color"),  0x01)
      ;

  TColorGroup &group1 =
    *new TColorGroup(_("Menus"))
      +*new _TColorItem(__("Normal"),  0x02)
      +*new _TColorItem(__("Disabled"),  0x03)
      +*new _TColorItem(__("Shortcut"),  0x04)
      +*new _TColorItem(__("Selected"),  0x05)
      +*new _TColorItem(__("Selected disabled"),  0x06)
      +*new _TColorItem(__("Shortcut selected"),  0x07)
      ;

  TColorGroup &group2 = windows_colors(_("Blue Windows"),0x08);

  TColorGroup &group3 = windows_colors(_("Cyan Windows"),0x10);

  TColorGroup &group4 = windows_colors(_("Gray Windows"),0x18);

  TColorGroup &group5 =
    *new TColorGroup(_("Dialogs"))
      +*new _TColorItem(__("Frame disabled"), 0x20)
      +*new _TColorItem(__("Frame/background"), 0x21)
      +*new _TColorItem(__("Frame icons"), 0x22)
      +*new _TColorItem(__("Scroll bar page"), 0x23)
      +*new _TColorItem(__("Scroll bar icons"), 0x24)
      +*new _TColorItem(__("Static text"), 0x25)
      +*new _TColorItem(__("Label normal"), 0x26)
      +*new _TColorItem(__("Label selected"), 0x27)
      +*new _TColorItem(__("Label shortcut"), 0x28)

      +*new _TColorItem(__("Button normal"),0x29)
      +*new _TColorItem(__("Button default"),0x2A)
      +*new _TColorItem(__("Button selected"),0x2B)
      +*new _TColorItem(__("Button disabled"),0x2C)
      +*new _TColorItem(__("Button shortcut"),0x2D)
      +*new _TColorItem(__("Button shadow"),0x2E)
      +*new _TColorItem(__("Cluster normal"),0x2F)
      +*new _TColorItem(__("Cluster selected"),0x30)
      +*new _TColorItem(__("Cluster shortcut"),0x31)

      +*new _TColorItem(__("Input normal"),0x32)
      +*new _TColorItem(__("Input selected"),0x33)
      +*new _TColorItem(__("Input arrow"),0x34)
      +*new _TColorItem(__("History button"),0x35)
      +*new _TColorItem(__("History sides"),0x36)
      +*new _TColorItem(__("History bar page"),0x37)
      +*new _TColorItem(__("History bar icons"),0x38)
      +*new _TColorItem(__("List normal"),0x39)
      +*new _TColorItem(__("List focused"),0x3A)
      +*new _TColorItem(__("List selected"),0x3B)
      +*new _TColorItem(__("List divider"),0x3C)
      +*new _TColorItem(__("Information pane"),0x3D)
      ;

  TColorGroup &group6 = editor_colors(_("Blue Editor"),0x40);

  TColorGroup &group7 = editor_colors(_("Cyan Editor"),0x60);

  TColorGroup &group8 = editor_colors(_("Gray Editor"),0x80);

  TColorGroup &group9 =
    *new TColorGroup(_("Info viewer"))
      +*new _TColorItem(__("Frame disabled"),  0xA0)
      +*new _TColorItem(__("Frame"),  0xA1)
      +*new _TColorItem(__("Frame icons"), 0xA2)
      +*new _TColorItem(__("Scroll bar page"), 0xA3)
      +*new _TColorItem(__("Scroll bar icons"), 0xA4)
      +*new _TColorItem(__("normal text"), 0xA5)
      +*new _TColorItem(__("keyword"), 0xA6)
      +*new _TColorItem(__("selected keyword"), 0xA7)
      +*new _TColorItem(__("marked keyword"), 0xA8)
#if 0
      +*new _TColorItem(__("marked text"), 0xA9)
#endif
      ;
  TColorGroup &group = 
     group0
    +group1
    +group2
    +group3
    +group4
    +group5
    +group6
    +group7
    +group8
    +group9
    ;

  if (temp_pal) delete temp_pal;
  temp_pal = new TPalette(TProgram::application->getPalette());
  c = new TColorDialog(&TProgram::application->getPalette(), &group );
  c->setData(&TProgram::application->getPalette());
  return c;
}

void Colors()
{
  TColorDialog *c = GetColorDialog();
  if (TProgram::application->validView( c ) != 0 )
  {
    if( TProgram::deskTop->execView( c ) == cmCancel )
    {
      // restore the old palette
      TProgram::application->getPalette() = *temp_pal;
    }
    // force to reread the chached colors for the editor
    TEditor::colorsCached = 0;
  
    Repaint();
    destroy(c);
  }
}



