/*----------------------------------------------------------*/
/*                                                          */
/*   Turbo Vision 1.0                                       */
/*   Copyright (c) 1991 by Borland International            */
/*                                                          */
/*   Turbo Vision TVEDIT source file                        */
/*----------------------------------------------------------*/

// That's the first include because is used to configure the editor.
#include "ceditint.h"

#define Uses_TDialog
#define Uses_TDeskTop
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TObject
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_THistory
#define Uses_TRect
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_TButton
#define Uses_TButton
#define Uses_MsgBox
#define Uses_TSItem
#define Uses_TStringCollection
#define Uses_fpstream

#define Uses_TKeys
#include <tv.h>

#define Uses_TCEditor
#define Uses_TCEditWindow
#include "ceditor.h"

#include "setconst.h"

#ifdef RHIDE
#define Uses_TEditorApp
#endif
#include "tvedit.h"

#include <stdlib.h>
#include <stdarg.h>
#include <strstrea.h>
#include <iomanip.h>

ushort execDialog( TDialog *d, void *data )
{
    TView *p = TProgram::application->validView( d );
    if( p == 0 )
        return cmCancel;
    else
        {
        if( data != 0 )
            p->setData( data );
        ushort result = TProgram::deskTop->execView( p );
        if( result != cmCancel && data != 0 )
            p->getData( data );
        TObject::destroy( p );
        return result;
        }
}

class TInputLinePiped : public TInputLine
{
public:
 TInputLinePiped( const TRect& bounds, int aMaxLen, int (*aPipe)(unsigned pos) );
 int (*PipeFun)(unsigned pos);
 void handleEvent( TEvent& event );
};

TInputLinePiped::TInputLinePiped( const TRect& bounds, int aMaxLen, int (*aPipe)(unsigned pos) ) :
TInputLine(bounds,aMaxLen),
PipeFun(aPipe)
{
}

void TInputLinePiped::handleEvent( TEvent& event )
{
 int Pos,Ret;
 if (event.what==evKeyDown && ctrlToArrow(event.keyDown.keyCode)==kbRight)
   {
    Pos=strlen(data);
    if (curPos>=Pos)
       if ((Ret=PipeFun(Pos))!=-1)
          if (Ret!='\r' && Ret!='\n' && Ret!='\t')
            {
             event.keyDown.keyCode=Ret;
             selStart = 0;
             selEnd = 0;
            }
   }
 TInputLine::handleEvent(event);
}

extern int PipeTCEditor(unsigned);


TDialog *createFindDialog()
{
    TDialog *d = new TDialog( TRect( 0, 0, 38, 20 ), _("Find") );

    d->options |= ofCentered;

    TInputLinePiped *control = new TInputLinePiped( TRect( 3, 3, 32, 4 ), 80, PipeTCEditor );
    d->insert( control );
    d->insert(
        new TLabel( TRect( 2, 2, 35, 3 ), _("~T~ext to find"), control ) );
    d->insert(
        new THistory( TRect( 32, 3, 35, 4 ), control, 10 ) );

    d->insert( new TCheckBoxes( TRect( 3, 5, 35, 7 ),
        new TSItem( _("~C~ase sensitive"),
        new TSItem( _("~W~hole words only"), 0 ))));

    // Scope
    TRadioButtons *scope = new TRadioButtons( TRect( 3, 9, 35, 11 ),
                           new TSItem( _("~G~lobal"),
                           new TSItem( _("~S~elected text"), 0 )));
    d->insert( scope );
    d->insert(
        new TLabel( TRect( 2, 8, 35, 9 ), _("Scope"), scope ) );

    // Origin
    TRadioButtons *origin = new TRadioButtons( TRect( 3, 13, 37, 15 ),
                            new TSItem( _("~F~rom cursor"),
                            new TSItem( _("~E~ntire scope"), 0 )));
    d->insert( origin );
    d->insert(
        new TLabel( TRect( 2, 12, 35, 13 ), _("Origin"), origin ) );

    d->insert(
        new TButton( TRect( 10, 17, 20, 19 ), _("O~K~"), cmOK, bfDefault ) );
    d->insert(
        new TButton( TRect( 22, 17, 36, 19 ), _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );
    return d;
}

TDialog *createReplaceDialog()
{
    TDialog *d = new TDialog( TRect( 0, 0, 76, 18 ), _("Replace") );

    d->options |= ofCentered;

    TInputLinePiped *control = new TInputLinePiped( TRect( 3, 3, 34, 4 ), 80, PipeTCEditor );
    d->insert( control );
    d->insert(
        new TLabel( TRect( 2, 2, 33, 3 ), _("~T~ext to find"), control ) );
    d->insert( new THistory( TRect( 34, 3, 37, 4 ), control, 10 ) );

    TInputLine *control2 = new TInputLine( TRect( 39, 3, 70, 4 ), 80 );
    d->insert( control2 );
    d->insert( new TLabel( TRect( 38, 2, 69, 3 ), _("~N~ew text"), control2 ) );
    d->insert( new THistory( TRect( 70, 3, 73, 4 ), control2, 11 ) );

    // Options
    TCheckBoxes *options = new TCheckBoxes( TRect( 3, 6, 37, 10 ),
        new TSItem(_("~C~ase sensitive"),
        new TSItem(_("~W~hole words only"),
        new TSItem(_("~P~rompt on replace"),
        new TSItem(_("~R~eplace all"), 0 )))));
    d->insert( options );
    d->insert(
        new TLabel( TRect( 2, 5, 35, 6 ), _("Options"), options ) );

    // Scope
    TRadioButtons *scope = new TRadioButtons( TRect( 3, 12, 37, 14 ),
                           new TSItem( _("~G~lobal"),
                           new TSItem( _("~S~elected text"), 0 )));
    d->insert( scope );
    d->insert(
        new TLabel( TRect( 2, 11, 35, 12 ), _("Scope"), scope ) );

    // Origin
    TRadioButtons *origin = new TRadioButtons( TRect( 39, 6, 73, 8 ),
                            new TSItem( _("~F~rom cursor"),
                            new TSItem( _("~E~ntire scope"), 0 )));
    d->insert( origin );
    d->insert(
        new TLabel( TRect( 38, 5, 71, 6 ), _("Origin"), origin ) );

    d->insert(
        new TButton( TRect( 49, 15, 59, 17 ), _("O~K~"), cmOK, bfDefault ) );
    d->insert(
        new TButton( TRect( 61, 15, 74, 17 ),_("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}

TDialog *createGotoLineDialog()
{
 TDialog *d = new TDialog( TRect( 0, 0, 33, 7 ), _("Goto Line") );
 d->options |= ofCentered;

 TInputLine *input = new TInputLine( TRect( 21, 2, 31, 3 ), 10 );
 d->insert( input );
 d->insert(
     new TLabel( TRect( 2, 2, 20, 3 ), _("Line number"), input ) );

 d->insert(
     new TButton( TRect( 2, 4, 12, 6 ), _("O~K~"), cmOK, bfDefault ) );
 d->insert(
     new TButton( TRect( 14, 4, 26, 6 ), _("Cancel"), cmCancel, bfNormal ) );

 d->selectNext( False );

 return d;
}

#define YSLOCheckB   2
#define AlSLOCheckB  10
#define YSLORadB     YSLOCheckB
#define AlSLORadB    4
#define YSLOLabRadB  (YSLORadB-1)
#define YSLOInTab    (YSLORadB+AlSLORadB+2)
#define YSLOButs     (YSLOCheckB+AlSLOCheckB+1)
#define AlSLO        YSLOButs+3

#define XSLOCheck    2
#define AnSLOCheck   37
#define XSLORad      (XSLOCheck+AnSLOCheck+2)
#define AnSLORad     33
#define XSLOTab      (XSLOCheck+AnSLOCheck+3)

#define AnSLO        (XSLORad+AnSLORad+3)

TDialog *createSetLocalOptions()
{
    TDialog *d = new TDialog( TRect( 0, 0, AnSLO , AlSLO ), _("Local Options") );

    d->options |= ofCentered;

    d->insert( new TCheckBoxes( TRect( XSLOCheck, YSLOCheckB, XSLOCheck+AnSLOCheck, YSLOCheckB+AlSLOCheckB ),
        new TSItem(_("~O~verwrite"),
        new TSItem(_("~A~utoindent"),
        new TSItem(_("~U~se tabs"),
        new TSItem(_("~P~ersistent blocks"),
        new TSItem(_("~I~nteligent C indent"),
        new TSItem(_("~C~olumn cursor"),
        new TSItem(_("~R~ow cursor"),
        new TSItem(_("~M~atch pair highligth"),
        new TSItem(_("Tra~n~sparent Blocks"),
        new TSItem(_("Optimal ~F~ill"), 0 ))))))))))));


    TRadioButtons *shl = new TRadioButtons( TRect( XSLORad, YSLORadB, XSLORad+AnSLORad, YSLORadB+AlSLORadB ),
                         new TSItem(_("O~f~f"),
                         new TSItem(_("~C~++ style"),
                         new TSItem(_("Pa~s~cal style"),
                         new TSItem(_("C~l~ipper style"), 0 )))));
    d->insert(shl);
    d->insert(
        new TLabel( TRect( XSLORad, YSLOLabRadB, XSLORad+AnSLORad, YSLOLabRadB+1 ), _("Syntax ~H~ighlight"), shl ) );

    TInputLine *tab = new TInputLine( TRect( XSLOTab, YSLOInTab, XSLOTab+5, YSLOInTab+1 ), 3 );
    d->insert( tab );
    d->insert(
        new TLabel( TRect( XSLOTab-1, YSLOInTab-1, XSLOTab+17, YSLOInTab ), _("~T~ab size"), tab ) );

    d->insert( new TButton( TRect( AnSLO-26, YSLOButs, AnSLO-16, YSLOButs+2 ),
               _("O~K~"), cmOK, bfDefault ) );
    d->insert( new TButton( TRect( AnSLO-14, YSLOButs, AnSLO-2, YSLOButs+2 ),
               _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}

#define YSGOCheckB   2
#define AlSGOCheckB  10
#define YSGORadB     (YSGOCheckB+AlSGOCheckB+2)
#define AlSGORadB    -2
#define YSGOLabRadB  (YSLORadB-1)
#define YSGOInTab    (YSGORadB+AlSGORadB+2)
#define YSGOButs     (YSGOInTab+2)
#define AlSGO        YSGOButs+3

TDialog *createSetGlobalOptions()
{
    TDialog *d = new TDialog( TRect( 0, 0, 44, AlSGO ), _("Global Options") );

    d->options |= ofCentered;

    d->insert( new TCheckBoxes( TRect( 3, YSGOCheckB, 41, YSGOCheckB+AlSGOCheckB ),
        new TSItem(_("~A~utoindent"),
        new TSItem(_("~U~se tabs"),
        new TSItem(_("~P~ersistent blocks"),
        new TSItem(_("~I~nteligent C indent"),
        new TSItem(_("~C~olumn cursor"),
        new TSItem(_("~R~ow cursor"),
        new TSItem(_("~M~atch pair highligth"),
        new TSItem(_("~D~on't move the cursor on Paste"),
        new TSItem(_("Tra~n~sparent Blocks"),
        new TSItem(_("Optimal ~F~ill"), 0 ))))))))))));


    TInputLine *tab = new TInputLine( TRect( 3, YSGOInTab, 8, YSGOInTab+1 ), 3 );
    d->insert( tab );
    d->insert(
        new TLabel( TRect( 2, YSGOInTab-1, 20, YSGOInTab ), _("~T~ab size"), tab ) );

    d->insert( new TButton( TRect( 4, YSGOButs, 14, YSGOButs+2 ),
               _("T~o~ all"), cmYes, bfNormal ) );
    d->insert( new TButton( TRect( 15, YSGOButs, 25, YSGOButs+2 ),
               _("O~K~"), cmOK, bfDefault ) );
    d->insert( new TButton( TRect( 26, YSGOButs, 38, YSGOButs+2 ),
               _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}
