#ifdef __DJGPP__
#define CCINDEX ccIndex
#else
#define CCINDEX short
#endif

class TDskWin : public TStreamable
{
public:
 TDskWin() {};
 virtual ~TDskWin() {};
 int type;
 int CanBeSaved;
 int ZOrder;
 TView *view;
 virtual int  GoAction(CCINDEX i) = 0;
 virtual int  DeleteAction(CCINDEX i) = 0;
 virtual int  Compare(void *,int) = 0;
 virtual char *GetText(char *dest, short maxLen) = 0;
 char *GetText(char *dest, char *s, short maxLen);
};

inline ipstream& operator >> ( ipstream& is, TDskWin& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDskWin*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDskWin& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDskWin* cl )
    { return os << (TStreamable *)cl; }


class TEditorCollection : public TCollection
{
public:

 TEditorCollection(ccIndex aLimit, ccIndex aDelta);
 void addEditor(TCEditWindow *p);
 void addNonEditor(TDskWin *p) { atInsert(Editors,p); nonEditors++; };
 void removeEditor(TCEditWindow *p);
 void getText(char *dest, CCINDEX item, short maxLen);
 ccIndex search(void *p,int type);
 ccIndex searchEditorName(const char *name);
 int Editors;
 int Closed;
 int nonEditors;

 const char *streamableName() const
     { return name; }
 void *readItem( ipstream& is );
 void writeItem( void *p, opstream &os );
 void write( opstream& os );
 void *read(ipstream& is);

protected:

    TEditorCollection( StreamableInit ) : TCollection ( streamableInit ) {};

public:

    static const char *name;
    static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TEditorCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TEditorCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TEditorCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TEditorCollection* cl )
    { return os << (TStreamable *)cl; }


class TListEditors : public TListBox
{
public:
 TListEditors(const TRect& bounds, ushort aNumCols, TScrollBar *aScrollBar) :
   TListBox(bounds,aNumCols,aScrollBar) {};
 virtual void getText(char *dest, CCINDEX item, short maxLen);
};


const dktEditor    = 1,
      dktClosed    = 2,
      dktClipboard = 3,
      dktHelp      = 4;

class TDskWinEditor : public TDskWin
{
public:

 TDskWinEditor(TCEditWindow *EdW,int Num) : edw(EdW), number(Num)
        { type=dktEditor; CanBeSaved=1; };
 ~TDskWinEditor() {};

 int  GoAction(CCINDEX i);
 int  DeleteAction(CCINDEX i);
 char *GetText(char *dest, short maxLen);
 int  Compare(void *p,int t) { return (t==dktEditor) && (p==edw); };

 TCEditWindow *edw;
 int number;

 void write( opstream& );
 void *read(ipstream& );

 const char *streamableName() const
     { return name; }

protected:

 TDskWinEditor( StreamableInit ) { type=dktEditor; CanBeSaved=1; };

public:

 static const char *name;
 static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDskWinEditor& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDskWinEditor*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDskWinEditor& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDskWinEditor* cl )
    { return os << (TStreamable *)cl; }


class TDskWinClosed : public TDskWin
{
public:

 TDskWinClosed(TCEditWindow *edw);
 ~TDskWinClosed();

 int  GoAction(CCINDEX i);
 int  DeleteAction(CCINDEX i);
 char *GetText(char *dest, short maxLen);
 int  Compare(void *p,int t) { return (t==dktClosed) && (strcmp((char *)p,Name)==0); };

 char *Name;
 TPoint origin;
 TPoint size;
 TPoint cursor;

 void write( opstream& os );
 void *read(ipstream& is);

 const char *streamableName() const
     { return name; }

protected:

 TDskWinClosed( StreamableInit ) { type=dktClosed; CanBeSaved=1; };

public:

 static const char *name;
 static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDskWinClosed& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDskWinClosed*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDskWinClosed& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDskWinClosed* cl )
    { return os << (TStreamable *)cl; }



class TDskWinClipboard : public TDskWin
{
public:

 TDskWinClipboard(TCEditWindow *edw);
 ~TDskWinClipboard() {};

 int  GoAction(CCINDEX i);
 int  DeleteAction(CCINDEX i);
 char *GetText(char *dest, short maxLen);
 int  Compare(void *p,int t) { return (t==dktClipboard) && p==(void *)edw; };

 TCEditWindow *edw;

 void write( opstream& os );
 void *read(ipstream& is);

 const char *streamableName() const
     { return name; }

protected:

 TDskWinClipboard( StreamableInit ) { type=dktClipboard; CanBeSaved=1; };

public:

 static const char *name;
 static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDskWinClipboard& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDskWinClipboard*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDskWinClipboard& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDskWinClipboard* cl )
    { return os << (TStreamable *)cl; }

class TInfFile;
class TInfWindow;

class TDskWinHelp : public TDskWin
{
public:

 TDskWinHelp(char *File, char *Node);
 ~TDskWinHelp() {};

 int  GoAction(CCINDEX i);
 int  DeleteAction(CCINDEX i);
 char *GetText(char *dest, short maxLen);
 int  Compare(void *,int t) { return (t==dktHelp); };

 TInfFile *file;
 TInfWindow *window;

 void Goto(char *File, char *Node);
 void Create(char *File, char *Node);

 void write( opstream& os );
 void *read(ipstream& is);

 const char *streamableName() const
     { return name; }

protected:

 TDskWinHelp( StreamableInit ) { type=dktHelp; CanBeSaved=1; };

public:

 static const char *name;
 static TStreamable *build();
};

inline ipstream& operator >> ( ipstream& is, TDskWinHelp& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDskWinHelp*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDskWinHelp& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDskWinHelp* cl )
    { return os << (TStreamable *)cl; }

