/***************************************************************/
/*                                                             */
/*  this header-file was modified by Robert Hoehne             */
/*  to use it with DJ's port of gcc                            */
/*                                                             */
/***************************************************************/

#if defined( Uses_TMacroRec ) && !defined( __TMacroRec )
#define __TMacroRec

typedef enum {
  Builtin_Command,
  Insert_Command,
  Macro_Command
} Macro_Type;

class TMacro;

struct TMacroRec : public TStreamable
{
  TMacroRec(StreamableInit) {}
  TMacroRec(ushort);
  TMacroRec(const char *);
  virtual ~TMacroRec();
  Macro_Type type;
  union {
    ushort command;
    char * Macro_Name;
  } data;
private:

    virtual const char *streamableName() const
	{ return name; }
public:

    static const char * const name;
    static TStreamable *build();
protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

  friend class TMacro;
};

inline ipstream& operator >> ( ipstream& is, TMacroRec& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TMacroRec*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TMacroRec& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TMacroRec* cl )
    { return os << (TStreamable *) cl; }

#endif

#if defined( Uses_TMacroCollection ) && !defined( __TMacroCollection )
#define __TMacroCollection

class TMacroCollection : public TSortedCollection
{
public:
    TMacroCollection() : TSortedCollection(0,1) {};
    TMacroCollection(StreamableInit) : TSortedCollection(streamableInit) {}
    void handleEvent(TEvent &,TView *);
private:

    virtual const char *streamableName() const
	{ return name; }
    virtual void writeItem(void *item, opstream& os);
    virtual void *readItem(ipstream& is);

protected:

    virtual int compare(void *, void *);

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TMacroCollection& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TMacroCollection*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TMacroCollection& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TMacroCollection* cl )
    { return os << (TStreamable *) cl; }

extern TMacroCollection *macros;

#endif

#if defined( Uses_TMacro ) && !defined( __TMacro )
#define __TMacro

struct TMacroRec;

class TMacro : public TStreamable
{

public:

    TMacro( StreamableInit ) {};
    TMacro(const char *,ushort keycode);
    TMacro(const char *,ushort keycode,ushort acommand);
    virtual ~TMacro();
    int count;
    TMacroRec **macs;
    ushort key;
    char * Macro_Name;

    void handleEvent(TEvent &,TView *);
    void insert(TMacroRec *);
private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TMacro& cl )
    { return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TMacro*& cl )
    { return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TMacro& cl )
    { return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TMacro* cl )
    { return os << (TStreamable *) cl; }

#endif
