/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   class pstream                                                         */
/*                                                                         */
/*   Base class for handling streamable objects.                           */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#if defined( Uses_pstream ) && !defined( __pstream )
#define __pstream

#if !defined( __IOSTREAM_H )
#include <iostream.h>
#endif  // __IOSTREAM_H

class far TStreamableTypes;

class pstream
{

    friend TStreamableTypes;

public:

    enum StreamableError { peNotRegistered, peInvalidType };
    enum PointerTypes { ptNull, ptIndexed, ptObject };

    _Cdecl pstream( streambuf _FAR * );
    virtual _Cdecl ~pstream();

    int _Cdecl rdstate() const;
    int _Cdecl eof() const;
    int _Cdecl fail() const;
    int _Cdecl bad() const;
    int _Cdecl good() const;
    void _Cdecl clear( int = 0 );
    _Cdecl operator void *() const;
    int _Cdecl operator ! () const;

    streambuf _FAR * _Cdecl rdbuf() const;

    static void initTypes();

    void _Cdecl error( StreamableError );
    void _Cdecl error( StreamableError, const TStreamable& );
    static void registerType( TStreamableClass *ts );

protected:

    _Cdecl pstream();

    streambuf _FAR *bp;
    int state;

    void _Cdecl init( streambuf _FAR * );
    void _Cdecl setstate( int );

    static TStreamableTypes * near types;

};

#endif  // Uses_pstream

