#if defined( Uses_TListViewer ) && !defined( __TListViewer )
#define __TListViewer

class far TRect;
class far TScrollBar;
class far TEvent;

class TListViewer : public TView
{

public:

    TListViewer( const TRect& bounds,
		 ushort aNumCols,
		 TScrollBar *aHScrollBar,
		 TScrollBar *aVScrollBar
	       );

    virtual void changeBounds( const TRect& bounds );
    virtual void draw();
    virtual void focusItem( ccIndex item );
    virtual TPalette& getPalette() const;
    virtual void getText( char *dest, ccIndex item, short maxLen );
    virtual Boolean isSelected( ccIndex item );
    virtual void handleEvent( TEvent& event );
    virtual void selectItem( ccIndex item );
    void setRange( ccIndex aRange );
    virtual void setState( ushort aState, Boolean enable );

    virtual void focusItemNum( ccIndex item );
    virtual void shutDown();

    TScrollBar *hScrollBar;
    TScrollBar *vScrollBar;
    short numCols;
    ccIndex topItem;
    ccIndex focused;
    ccIndex range;

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    TListViewer( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TListViewer& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TListViewer*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TListViewer& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TListViewer* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TListViewer

