/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   class ipstream                                                        */
/*                                                                         */
/*   Base class for reading streamable objects                             */
/*                                                                         */
/* ------------------------------------------------------------------------*/

#if defined( Uses_ipstream ) && !defined( __ipstream )
#define __ipstream

#if !defined( __IOSTREAM_H )
#include <iostream.h>
#endif  // __IOSTREAM_H

class far TStreamableClass;

class ipstream : virtual public pstream
{

public:

    _Cdecl ipstream( streambuf _FAR * );
    _Cdecl ~ipstream();

    streampos _Cdecl tellg();
    ipstream& _Cdecl seekg( streampos );
    ipstream& _Cdecl seekg( streamoff, ios::seek_dir );

    uchar _Cdecl readByte();
    void _Cdecl readBytes( void _FAR *, size_t );
    ushort _Cdecl readWord();
    char _FAR * _Cdecl readString();
    char _FAR * _Cdecl readString( char _FAR *, unsigned );

    friend ipstream& _Cdecl operator >> ( ipstream&, char& );
#ifndef __TURBOC__
    friend ipstream& _Cdecl operator >> ( ipstream&, signed char& );
#endif
    friend ipstream& _Cdecl operator >> ( ipstream&, unsigned char& );
    friend ipstream& _Cdecl operator >> ( ipstream&, signed short& );
    friend ipstream& _Cdecl operator >> ( ipstream&, unsigned short& );
    friend ipstream& _Cdecl operator >> ( ipstream&, signed int& );
    friend ipstream& _Cdecl operator >> ( ipstream&, unsigned int& );
    friend ipstream& _Cdecl operator >> ( ipstream&, signed long& );
    friend ipstream& _Cdecl operator >> ( ipstream&, unsigned long& );
    friend ipstream& _Cdecl operator >> ( ipstream&, float& );
    friend ipstream& _Cdecl operator >> ( ipstream&, double& );
    friend ipstream& _Cdecl operator >> ( ipstream&, long double& );

    friend ipstream& _Cdecl operator >> ( ipstream&, TStreamable& );
    friend ipstream& _Cdecl operator >> ( ipstream&, void _FAR *& );

protected:

    _Cdecl ipstream();

    const TStreamableClass _FAR * _Cdecl readPrefix();
    void _FAR * _Cdecl readData( const TStreamableClass _FAR *,
                                        TStreamable _FAR * );
    void _Cdecl readSuffix();

    const void _FAR * _Cdecl find( P_id_type );
    void _Cdecl registerObject( const void _FAR *adr );

private:

    TPReadObjects objs;

};

#endif  // Uses_ipstream

