#if defined( Uses_TFileList ) && !defined( __TFileList )
#define __TFileList

class far TRect;
class far TScrollBar;
class far TEvent;

class TFileList : public TSortedListBox
{

public:

    TFileList( const TRect& bounds,
	       TScrollBar *aScrollBar
	     );
    ~TFileList();

    virtual void focusItem( ccIndex item );
    virtual void getText( char *dest, ccIndex item, short maxLen );
    virtual void handleEvent( TEvent& event );
    void newList( TFileCollection *aList );
    void readDirectory( const char *dir, const char *wildCard );
    void readDirectory( const char *wildCard );

    virtual uint32 dataSize();
    virtual void getData( void *rec );
    virtual void setData( void *rec );

    TFileCollection *list();

private:

    virtual void *getKey( const char *s );

//    static const char * near tooManyFiles;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TFileList( StreamableInit ) : TSortedListBox ( streamableInit ) {}

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TFileList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TFileList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TFileList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TFileList* cl )
    { return os << (TStreamable *)cl; }

inline void TFileList::newList( TFileCollection *f )
{
    TSortedListBox::newList( f );
}

inline TFileCollection *TFileList::list()
{
    return (TFileCollection *)TSortedListBox::list();
}

#endif  // Uses_TFileList

