#if defined( Uses_TDirListBox ) && !defined( __TDirListBox )
#define __TDirListBox

class far TRect;
class far TScrollBar;
class far TEvent;
class far TDirCollection;

#include <dir.h> // for MAXPATH

class TDirListBox : public TListBox
{

public:

    TDirListBox( const TRect& bounds, TScrollBar *aScrollBar );
    ~TDirListBox();

    virtual void getText( char *, ccIndex, short );
    virtual void handleEvent( TEvent& );
    virtual Boolean isSelected( ccIndex );
    void newDirectory( const char * );
    virtual void setState( ushort aState, Boolean enable );

    TDirCollection *list();

private:

    void showDrives( TDirCollection * );
    void showDirs( TDirCollection * );

#ifndef USE_LFN
    char dir[MAXPATH];
#else
    char dir[MAXPATH];
#endif
    ushort cur;

    static const char * near pathDir;
    static const char * near firstDir;
    static const char * near middleDir;
    static const char * near lastDir;
    static const char * near graphics;

    virtual const char *streamableName() const
        { return name; }

protected:

    TDirListBox( StreamableInit ): TListBox( streamableInit ) {}

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TDirListBox& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TDirListBox*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TDirListBox& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TDirListBox* cl )
    { return os << (TStreamable *)cl; }

inline TDirCollection *TDirListBox::list()
{
    return (TDirCollection *)TListBox::list();
}

#endif  // Uses_TDirListBox

