#if defined( Uses_TColorSelector ) && !defined( __TColorSelector )
#define __TColorSelector

class far TRect;
class far TEvent;

class TColorSelector : public TView
{

public:

    enum ColorSel { csBackground, csForeground };

    TColorSelector( const TRect& Bounds, ColorSel ASelType );
    virtual void draw();
    virtual void handleEvent( TEvent& event );

protected:

    uchar color;
    ColorSel selType;

private:

    void colorChanged();

    static const char near icon;

    virtual const char *streamableName() const
        { return name; }

protected:

    TColorSelector( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorSelector& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorSelector*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorSelector& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorSelector* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TColorSelector

