#if defined( Uses_TColorItemList ) && !defined( __TColorItemList )
#define __TColorItemList

class far TRect;
class far TScrollBar;
class far TColorItem;
class far TEvent;

class TColorItemList : public TListViewer
{

public:

    TColorItemList( const TRect& bounds,
		    TScrollBar *aScrollBar,
		    TColorItem *aItems
		  );
    virtual void focusItem( ccIndex item );
    virtual void getText( char *dest, ccIndex item, short maxLen );
    virtual void handleEvent( TEvent& event );

protected:

    TColorItem *items;

private:

    virtual const char *streamableName() const
        { return name; }

protected:

    TColorItemList( StreamableInit );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorItemList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorItemList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorItemList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorItemList* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TColorItemList

