#if defined( Uses_TColorGroupList ) && !defined( __TColorGroupList )
#define __TColorGroupList

class far TRect;
class far TScrollBar;
class far TColorGroup;
class far TColorItem;

class TColorGroupList : public TListViewer
{

public:

    TColorGroupList( const TRect& bounds,
                     TScrollBar *aScrollBar,
                     TColorGroup *aGroups
                   );
    virtual ~TColorGroupList();
    virtual void focusItem( ccIndex item );
    virtual void getText( char *dest, ccIndex item, short maxLen );

protected:

    TColorGroup *groups;

private:

    virtual const char *streamableName() const
        { return name; }
    static void writeItems( opstream&, TColorItem * );
    static void writeGroups( opstream&, TColorGroup * );
    static TColorItem *readItems( ipstream& );
    static TColorGroup *readGroups( ipstream& );

protected:

    TColorGroupList( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorGroupList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorGroupList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorGroupList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorGroupList* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TColorGroupList

