#if defined( Uses_TColorDisplay ) && !defined( __TColorDisplay )
#define __TColorDisplay

class far TRect;
class far TEvent;

class TColorDisplay : public TView
{

public:

    TColorDisplay( const TRect& bounds, const char *aText );
    virtual ~TColorDisplay();
    virtual void draw();
    virtual void handleEvent( TEvent& event );
    virtual void setColor( uchar *aColor );

protected:

    uchar *color;
    const char *text;

private:

    virtual const char *streamableName() const
        { return name; }

protected:

    TColorDisplay( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorDisplay& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorDisplay*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorDisplay& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorDisplay* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TColorDisplay

