#define Uses_TParamText
#include <tv.h>
#include <stdio.h>

TParamText::TParamText( const TRect& bounds,
                        const char *aText,
                        int aParamCount ) :
    TStaticText(bounds, aText),
    paramCount( aParamCount ),
    paramList( 0 )
{
}

uint32 TParamText::dataSize()
{
    return paramCount * sizeof(long);
}

void TParamText::getText( char *s )
{
    if( text == 0 )
        *s = EOS;
    else
        vsprintf( s, text, paramList );
}

void TParamText::setData( void *rec )
{
    paramList = &rec;
}

void TParamText::write( opstream& os )
{
    TStaticText::write( os );
    os << paramCount;
}

void *TParamText::read( ipstream& is )
{
    TStaticText::read( is );
    is >> paramCount;
    paramList = 0;
    return this;
}

TStreamable *TParamText::build()
{
    return new TParamText( streamableInit );
}

TParamText::TParamText( StreamableInit ) : TStaticText( streamableInit )
{
}


