#define Uses_TFileInputLine
#define Uses_TEvent
#define Uses_TSearchRec
#define Uses_TFileInfoPane
#define Uses_TDrawBuffer
#define Uses_TFileDialog
#define Uses_TPalette
#include <tv.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define cpInfoPane "\x1E"

TFileInfoPane::TFileInfoPane( const TRect& bounds ) :
    TView(bounds)
{
    eventMask |= evBroadcast;
}

const char * const TFileInfoPane::months[] =
    {
    __(""),__("Jan"),__("Feb"),__("Mar"),__("Apr"),__("May"),__("Jun"),
    __("Jul"),__("Aug"),__("Sep"),__("Oct"),__("Nov"),__("Dec")
    };

void TFileInfoPane::draw()
{
    Boolean PM;
    TDrawBuffer b;
    ushort  color;
#if 1
    struct tm *time;
#else
    ftime *time;
#endif
    char path[MAXLFNPATH];

    strcpy( path, ((TFileDialog *)owner)->directory );
    strcat( path, ((TFileDialog *)owner)->wildCard );
    fexpand( path );

    color = getColor(0x01);
    b.moveChar( 0, ' ', color, size.x );
    b.moveStr( 1, path, color );
    writeLine( 0, 0, size.x, 1, b );

    b.moveChar( 0, ' ', color, size.x );
    b.moveStr( 1, file_block.name, color );

//    if (_USE_LFN)
    {
      writeLine( 0, 1, size.x, 1, b);
      b.moveChar( 0, ' ', color, size.x );
    }
    if( *(file_block.name) != EOS )
        {

        char buf[10];
        ltoa( file_block.size, buf, 10 );
        b.moveStr( 14, buf, color );

#if 1
        time = localtime(&file_block.time);
        b.moveStr( 25, _(months[time->tm_mon]), color );

        if( time->tm_mday >= 10 )
            itoa( time->tm_mday, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->tm_mday, buf+1, 10 );
            }
        b.moveStr( 29, buf, color );

        b.putChar( 31, ',' );

        itoa( time->tm_year+1900, buf, 10 );
        b.moveStr( 32, buf, color );

        PM = Boolean(time->tm_hour >= 12 );
        time->tm_hour %= 12;

        if( time->tm_hour == 0 )
            time->tm_hour = 12;

        if( time->tm_hour >= 10 )
            itoa( time->tm_hour, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->tm_hour, buf+1, 10 );
            }
        b.moveStr( 38, buf, color );
        b.putChar( 40, ':' );

        if( time->tm_min >= 10 )
            itoa( time->tm_min, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->tm_min, buf+1, 10 );
            }
        b.moveStr( 41, buf, color );

        if( PM )
            b.moveStr( 43, pmText, color );
        else
            b.moveStr( 43, amText, color );
#else
        time = (ftime *) &file_block.time;
        b.moveStr( 25, _(months[time->ft_month]), color );

        if( time->ft_day >= 10 )
            itoa( time->ft_day, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->ft_day, buf+1, 10 );
            }
        b.moveStr( 29, buf, color );

        b.putChar( 31, ',' );

        itoa( time->ft_year+1980, buf, 10 );
        b.moveStr( 32, buf, color );

        PM = Boolean(time->ft_hour >= 12 );
        time->ft_hour %= 12;

        if( time->ft_hour == 0 )
            time->ft_hour = 12;

        if( time->ft_hour >= 10 )
            itoa( time->ft_hour, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->ft_hour, buf+1, 10 );
            }
        b.moveStr( 38, buf, color );
        b.putChar( 40, ':' );

        if( time->ft_min >= 10 )
            itoa( time->ft_min, buf, 10 );
        else
            {
            buf[0] = '0';
            itoa( time->ft_min, buf+1, 10 );
            }
        b.moveStr( 41, buf, color );

        if( PM )
            b.moveStr( 43, pmText, color );
        else
            b.moveStr( 43, amText, color );
#endif
        }
//    if (_USE_LFN)
    writeLine(0, 2, size.x, 1, b );
//    else
//    writeLine(0, 1, size.x, 1, b );
    b.moveChar( 0, ' ', color, size. x);
//    if (_USE_LFN)
    writeLine( 0, 3, size.x, size.y-3, b);
//    else
//    writeLine( 0, 2, size.x, size.y-2, b);
}

TPalette& TFileInfoPane::getPalette() const
{
    static TPalette palette( cpInfoPane, sizeof( cpInfoPane )-1 );
    return palette;
}

void TFileInfoPane::handleEvent( TEvent& event )
{
    TView::handleEvent(event);
    if( event.what == evBroadcast && event.message.command == cmFileFocused )
        {
        file_block = *((TSearchRec *)(event.message.infoPtr));
        drawView();
        }
}

TStreamable *TFileInfoPane::build()
{
    return new TFileInfoPane( streamableInit );
}
