#define Uses_TKeys
#define Uses_TEvent
#define Uses_TWindow
#define Uses_TCollection

#define Uses_tvutilCommands
#define Uses_TWindowList
#include <libtvuti.h>
#include <string.h>
#include <stdio.h>

TWindowList::TWindowList(const TRect & bounds,ushort aNumCols,
                         TScrollBar *aScrollBar) :
    TEnterListBox(bounds,aNumCols,aScrollBar)
{
  helpCtx = hcWindowList;
}

void TWindowList::selectItem(ccIndex item)
{
  TEnterListBox::selectItem(item);
  endModal(cmSelectWindow);
}

void TWindowList::handleEvent(TEvent & event)
{
  TEnterListBox::handleEvent(event);
  switch (event.what)
  {
    case evCommand:
      switch (event.message.command)
      {
	case cmSelectWindow:
	case cmDeleteWindow:
	  endModal(event.message.command);
	  clearEvent(event);
	  break;
	default:
	  break;
      }
      break;
    default:
      break;
  }
}

void TWindowList::newList(TCollection *coll)
{
  if (list() == NULL) TEnterListBox::newList(coll);
  else
  {
    if (coll != 0)
    {
      setRange(coll->getCount());
      if (focused < range) focusItem(focused);
      else if (range > 0) focusItem(range-1);
    }
    else
    {
      setRange(0);
    }
    drawView();
  }
}

void TWindowList::getText(char *dest,ccIndex item,short maxlen)
{
  if (list() == NULL) strcpy(dest," ");
  else
  {
    TWindow *window = ((DeskTopWindow *)list()->at(item))->window;
    if (window->number != wnNoNumber)
    {
      sprintf(dest,"%d ",window->number);
    }
    else strcpy(dest,"  ");
    strcat(dest,window->getTitle(maxlen-strlen(dest)));
  }
}
