/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TStreamable
#define Uses_TScreen
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TApplication

#define Uses_tvutilFunctions
#include <libtvuti.h>

#define Uses_TProject
#define Uses_TOptions
#define Uses_TDepCollection
#include <libide.h>

static ushort TProject_Version = 3;

TProject::TProject() : TDependency()
{
  options = new TOptions();
  string_dup(defaultprojectmask,"*.[chmps]*");
  dependencies = new TDepCollection(5,5);
  screen_mode = 3;
  tabsize = 8;
  options1 = 0;
}

TProject & TProject::operator = ( const TProject& prj)
{
  *options = *prj.options;
  string_free(defaultprojectmask);
  string_dup(defaultprojectmask,prj.defaultprojectmask);
  screen_mode = prj.screen_mode;
  tabsize = prj.tabsize;
  options1 = prj.options1;
  return *this;
}

TProject::~TProject()
{
  destroy(options);
  string_free(defaultprojectmask);
}

TStreamable *TProject::build()
{
  return new TProject( streamableInit );
}

void * TProject::read(ipstream & is)
{
  ushort version;
  is >> version;
  TDependency::read(is);
  is >> options;
  defaultprojectmask = is.readString();
  if (version >= 2)
  {
    is >> tabsize;
    is >> screen_mode;
  }
  else
  {
    tabsize = 8;
    screen_mode = 3;
  }
  if (version >= 3)
    is >> options1;
  else
    options1 = 0;
  return this;
}

void TProject::write(opstream & os)
{
  os << TProject_Version;
  TDependency::write(os);
  os << options;
  os.writeString(defaultprojectmask);
  os << tabsize;
  os << screen_mode;
  os << options1;
}


